<?php

namespace App\Livewire;

use App\Models\Button;
use App\Models\Sale;
use App\Models\SaleImage;
use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Mail;

class CashCarry extends Component
{
    use WithFileUploads;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;

    public $card_title;
    public $username;
    public $user;
    public $fullname;
    public $favicon;
    public $sale_image;
    public $directions;

    public $showFooter;

    //footer by user
    public ?string $footer_text;
    public ?string $footer_link;

    //footer by user
    public ?string $default_footer_text;
    public ?string $default_footer_link;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public $user_id;

    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    public $condition;
    public $sales_images, $sales;
    public $payments;
    public $message;

    public $preferred_contact = 'Text';
    public $firstname, $lastname, $phone, $receipt, $sender_email;
    public $sales_id;

    public function cashCarryForm()
    {
        $validated = $this->validate(
            [
                'firstname' => 'required|string|max:50',
                'lastname' => 'required|string|max:50',
                'sender_email' => 'required|email',
                'phone' => 'required|regex:/^[\d\s\-\+\(\)]+$/|max:20',
                'preferred_contact' => 'required|in:Text,WhatsApp,Email',
                'receipt' => 'required|file|mimes:jpg,jpeg,png,pdf|max:2048', // 2MB limit
            ],
            [
                'firstname.required' => 'This field is required.',
                'lastname.required' => 'This field is required.',
                'phone.regex' => 'Please enter a valid phone number.',
                'receipt.max' => 'Receipt must be less than 2MB.',
            ]
        );

        $receipt_path = $this->receipt->store('receipts', 'public');
        $receipt_url  = Storage::url($receipt_path);

        // $body = "Hey {$this->user->firstname}, this is {$validated['firstname']} {$validated['lastname']}.\n\n"
        //     . "I’d like to purchase <a href='https://10kcards.site/{$this->user->username}/sales/{$this->sales_id}/cash-and-carry/{$this->sale_image->id}' target='_blank'>https://10kcards.site/{$this->user->username}/sales/{$this->sales_id}/cash-and-carry/{$this->sale_image->id}</a> and have attached the payment receipt.\n\n"
        //     . "Download Receipt: <a href='{url($receipt_url)}' target='_blank'>" . url($receipt_url) . "</a>\n\n"
        //     . "You can reach me at: <a href='mailto:{$validated['sender_email']}' target='_blank'>{$validated['sender_email']}</a>.\n\n"
        //     . "It’s great connecting with you!\n\n"
        //     . "<a href='{https://10kcards.site/{$this->user->username}}' target='_blank'>https://10kcards.site/{$this->user->username}/</a>";

        // $body = "Hey {$this->user->firstname}, this is {$validated['firstname']} {$validated['lastname']}.<br><br>"
        //     . "I’d like to purchase <a href='https://10kcards.site/{$this->user->username}/sales/{$this->sales_id}/cash-and-carry/{$this->sale_image->id}' target='_blank'>"
        //     . "https://10kcards.site/{$this->user->username}/sales/{$this->sales_id}/cash-and-carry/{$this->sale_image->id}</a> and have attached the payment receipt.<br><br>"
        //     . "Download Receipt: <a href='" . url($receipt_url) . "' target='_blank'>" . url($receipt_url) . "</a><br><br>"
        //     . "You can reach me at: <a href='mailto:{$validated['sender_email']}' target='_blank'>{$validated['sender_email']}</a>.<br><br>"
        //     . "It’s great connecting with you!<br><br>"
        //     . "<a href='https://10kcards.site/{$this->user->username}' target='_blank'>https://10kcards.site/{$this->user->username}/</a>";

        $body = "Hey {$this->user->firstname}, this is {$validated['firstname']} {$validated['lastname']}.<br><br>"
            . "I’d like to purchase <a href='{$this->site_url}/{$this->user->username}/sales/{$this->sales_id}/cash-and-carry-video/{$this->sale_video->id}' target='_blank'>"
            . "{$this->site_url}/{$this->user->username}/sales/{$this->sales_id}/cash-and-carry-video/{$this->sale_video->id}</a> and have attached the payment receipt.<br><br>"
            . "Download Receipt: <a href='" . url($receipt_url) . "' target='_blank'>" . url($receipt_url) . "</a><br><br>"
            . "You can reach me at: <a href='mailto:{$validated['sender_email']}' target='_blank'>{$validated['sender_email']}</a>.<br><br>"
            . "It’s great connecting with you!<br><br>"
            . "<a href='{$this->site_url}/{$this->user->username}' target='_blank'>{$this->site_url}/{$this->user->username}/</a>";


        try {
            // Message for Text and WhatsApp
            // $message = "Hey {$this->user->firstname}, this is {$validated['firstname']} {$validated['lastname']}.%0A%0A"
            //     . "I’d like to purchase https://10kcards.site/{$this->user->username}/sales/{$this->sales_id}/cash-and-carry/{$this->sale_image->id} and have attached the payment receipt.%0A%0A"
            //     . "Download Receipt: " . url($receipt_url) . "%0A%0A"
            //     . "You can reach me at: {$validated['sender_email']}.%0A%0A"
            //     . "It’s great connecting with you!%0A%0A"
            //     . "https://10kcards.site/{$this->user->username}/";

            $message = "Hey {$this->user->firstname}, this is {$validated['firstname']} {$validated['lastname']}.%0A%0A"
                . "I’d like to purchase {$this->site_url}/{$this->user->username}/sales/{$this->sales_id}/cash-and-carry-video/{$this->sale_video->id} and have attached the payment receipt.%0A%0A"
                . "Download Receipt: " . url($receipt_url) . "%0A%0A"
                . "You can reach me at: {$validated['sender_email']}.%0A%0A"
                . "It’s great connecting with you!%0A%0A"
                . "{$this->site_url}/{$this->user->username}/";


            // Build URLs (notice: no urlencode(), we use %0A directly)
            $smsUrl = "sms:{$this->user->phone}?body={$message}";
            $whatsappUrl = "https://wa.me/{$this->user->phone}?text={$message}";

            if ($validated['preferred_contact'] === 'Text') {
                return redirect()->to($smsUrl);
            } elseif ($validated['preferred_contact'] === 'WhatsApp') {
                return redirect()->to($whatsappUrl);
            } else {
                Mail::html($body, function ($mail) use ($validated) {
                    $mail->to($this->user->email)
                        ->from(config('mail.from.address'), config('mail.from.name'))
                        ->replyTo($validated['sender_email'])
                        ->subject('Cash and Carry');
                });

                session()->flash('success', "Email sent to {$this->user->email}");

                return redirect(request()->header('Referer'));
            }
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
        }
    }

    public function displayProduct($username, $sales, $sales_images)
    {
        // get user creds
        $this->username = $username;
        $this->sales = $sales;
        $this->sales_images = $sales_images;
        $this->sales_id = $sales->id;

        if ($this->mainCard == true) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first(['email', 'phone', 'profile_pic', 'thumbnail', 'username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'language', 'address', 'country', 'id', 'user_type']);
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.username', $this->username)
                ->first([
                    'subcards.id',
                    'subcards.user_id',
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'subcards.thumbnail',
                    'users.firstname',
                    'users.lastname',
                    'users.address',
                    'users.country',
                    'users.user_type',
                    'subcards.email',
                    'subcards.phone',
                    'users.id',
                ]);
        }

        if (!isset($this->username)) {
            $this->user = 0;
        }

        // If user exist
        if ($this->user) {

            // $this->favicon = $this->user->profile_pic;
            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            // Set the fullanme
            $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;

            $this->sale_image = SaleImage::where('is_active', true)
                ->where('id', $sales_images)
                ->where('sales_id', $sales->id)
                // ->where($this->condition)
                ->orderBy('order', 'asc')
                ->first();

            //if user exist, get direction links
            $this->directions = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'directions')
                ->orderBy('order', 'asc')
                ->get();

            // dd($sales_images, $sales->id);
            // Card title
            $this->card_title = UserSettings::where($this->condition)
                ->where('setting_key', 'card_custom_title')
                ->pluck('setting_value')
                ->first();

            $this->footer_text = UserSettings::where('setting_key', 'footer_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->footer_link = UserSettings::where('setting_key', 'footer_link')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //if footer text and link not already set, set to true
            if ($this->footer_text == NULL && $this->footer_link == NULL) {
                $this->showFooter = true;
            }

            if ($this->footer_text && $this->footer_link) {
                $this->showFooter = true;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }

            if ($this->directions->isEmpty()) {
                $this->directions = 0;
            }

            if (!$this->sale_image) {
                $this->sale_image = 0;
                $this->card_title = "Product not found";
            }
        } else {
            $this->user = 0;

            $this->card_title = "Product not found";
        }
    }

    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;

        $this->default_footer_text = $default->footer_text;
        $this->default_footer_link = $default->footer_link;
    }

    public function mount($username, Sale $sales, $sales_images)
    {
        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $this->username)->count();
        $this->checkSub = SubCard::where('username', $this->username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $this->username)
                ->pluck('id')
                ->first();
            $this->mainCard = false;
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        //if user exist, get payment links
        $this->payments = Button::where('is_active', true)
            ->where($this->condition)
            ->where('view', 'payments')
            ->orderBy('order', 'asc')
            ->get();

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';

        if ($this->payments->isEmpty()) {
            $this->payments = 0;
        }

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->displayProduct($username, $sales, $sales_images);
    }

    public function render()
    {
        // dd($this->sale_image);
        return view('livewire.cash-carry')->title($this->card_title)->layoutData([
            'favicon' => $this->favicon,
            'username' => $this->username,
            'site_url' => $this->site_url,
            'thumbnail' => $this->thumbnail,
            'title' => $this->card_title,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
        ]);
    }
}
