<?php

namespace App\Livewire;

use App\Models\Button;
use App\Models\SubCard;
use App\Models\User;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;

class ButtonPage extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $buttons;
    public $user_type;
    public $condition;

    public $user;
    public $button_count;

    public $page_id; //subcard id, used in query

    public function buttonManager()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();
        // if active, get the datas and set to form
        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'user_type']);
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {

            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'users.firstname',
                    'users.lastname',
                    'users.user_type',
                ]);

            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->buttons = Button::where($this->condition)->where('view', 'links')->get();

        if ($this->buttons->isEmpty()) {
            $this->buttons = 0;
        }

        // $this->user_type = auth()->user()->user_type;

        $this->button_count = auth()->user()
            ->buttons()
            ->where('view', 'links')
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'trusted_network'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'reviews'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'zoom_replay'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'team'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'services'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'shop'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'bio'))
            ->when(!in_array($this->user->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'events'))
            ->when(!in_array($this->user->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'feedback'))
            ->when(!in_array($this->user->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'help'))
            ->when(!in_array($this->user->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'exchange'))
            ->where($this->condition)
            ->count();
    }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->buttonManager();
    }

    public function render()
    {
        return view('pages.button')
            ->title('Links | ' . $this->site_name)->layoutData([
                'thumbnail' => $this->thumbnail,
                'app_name' => $this->app_name,
            ]);
    }
}
