<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Auth;
use App\Helpers\SavingLinkHelpers;
use App\Models\Button;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Route;

class ButtonEditActionSheet extends Component
{
    public $id;
    public $link;
    public $title;
    public $type;
    public $view;
    public $display_as = 'button';
    public $routeName;

    // Assign value to be updated
    #[On('send_id')]
    public function get_button_id($id)
    {
        $this->id = $id;
    }

    // Assign value in link field
    #[On('send_link')]
    public function get_button_link($link)
    {
        $this->link = $link;
    }

    // Assign value in the title field
    #[On('send_title')]
    public function get_button_title($title)
    {
        $this->title = $title;
    }

    public function update_button($type)
    {

        try {
            $this->type = $type;

            if (!in_array($this->type, ['vcf', 'help', 'exchange', 'feedback', 'bio', 'shop', 'services', 'events', 'sales', 'reviews', 'zoom_replay', 'trusted_network', 'payments'])) {
                $validated = $this->validate([
                    'title' => 'required|string|max:100',
                    'display_as' => 'required|in:button,icon',
                    'link' => 'required|string',
                    'type' => 'required|in:link,podcast,community,email,phone,sms,whatsapp,zalo,wechat,telegram,zoom,cashapp,payment_other,chime,square,paypal_link,paypal_email,apple_pay,venmo,credit,zelle,google_map,apple_map,waze,amazon_shop'
                ]);
            } else {
                $validated = $this->validate([
                    'title' => 'required|string|max:100',
                    'type' => 'required|in:vcf,help,exchange,feedback,bio,shop,zoom_replay,reviews,services,events,sales,trusted_network,payments'
                ]);
            }

            if (auth()->user()->user_type == 'Free') {
                // dd($this->routeName);
                if ($this->routeName === 'contacts.index') {
                    $validated['display_as'] = 'icon';
                } else {
                    $validated['display_as'] = 'button';
                }
            }

            if (!in_array($this->type, ['vcf', 'help', 'exchange', 'feedback', 'bio', 'shop', 'services', 'events', 'sales', 'reviews', 'zoom_replay', 'trusted_network', 'payments'])) {
                //after validating, assign "view" based on "type"
                if ($validated['display_as'] === 'icon') {
                    //check the link type to determine how to display it on the card
                    if (in_array($this->type, ['cashapp', 'payment_other', 'chime', 'square', 'paypal_link', 'paypal_email', 'apple_pay', 'venmo', 'credit', 'zelle'])) {

                        //save the view as 'payments'
                        $validated['view'] = 'payments';
                    } else if (in_array($this->type, ['email', 'phone', 'sms', 'whatsapp', 'zalo', 'wechat', 'telegram', 'zoom', 'community', 'amazon_shop'])) {

                        //save the view as 'contacts'
                        $validated['view'] = 'contacts';
                    }
                } else {
                    //save the view as 'links'
                    // $validated['view'] = 'links';

                    if ($validated['display_as'] === 'button' && !in_array($this->type, ['google_map', 'apple_map', 'waze'])) {
                        //save the view as 'links'
                        $validated['view'] = 'links';
                    }

                    if (in_array($this->type, ['google_map', 'apple_map', 'waze'])) {
                        $validated['view'] = 'directions';
                    }
                }
            }

            // run validations
            try {
                $update = Button::where('id', $this->id)
                    ->where('user_id', auth()->id())
                    ->firstOrFail();

                if (!in_array($this->type, ['vcf', 'help', 'exchange', 'feedback', 'bio', 'shop', 'services', 'events', 'sales', 'reviews', 'zoom_replay', 'trusted_network', 'payments'])) {
                    $update->update([
                        'title' => $validated['title'],
                        'link' => $validated['link'],
                        'type' => $validated['type'],
                        'view' => $validated['view'],
                    ]);
                } else {
                    $update->update([
                        'title' => $validated['title'],
                        'type' => $validated['type'],
                    ]);
                }
            } catch (\Exception $e) {
                session()->flash('error', $e->getMessage());
                return redirect()->back();
            }

            if ($update) {
                if (!in_array($this->type, ['vcf', 'help', 'exchange', 'feedback', 'bio', 'shop', 'services', 'events', 'sales', 'reviews', 'zoom_replay', 'trusted_network', 'payments'])) {
                    if ($validated['display_as'] === 'icon') {
                        //check the link type to determine how to display it on the card
                        if (in_array($this->type, ['cashapp', 'chime', 'square', 'payment_other', 'paypal_link', 'paypal_email', 'apple_pay', 'venmo', 'credit', 'zelle'])) {
                            session()->flash('success', 'Payment link successfully updated!');
                            return $this->redirect('/dashboard/payments', navigate: true);
                        } else if (in_array($this->type, ['email', 'phone', 'sms', 'whatsapp', 'zalo', 'wechat', 'telegram', 'zoom', 'community', 'amazon_shop'])) {
                            session()->flash('success', 'Contact point successfully updated!');
                            return $this->redirect('/dashboard/contacts', navigate: true);
                        }
                    } else {
                        if (in_array($this->type, ['cashapp', 'chime', 'square', 'payment_other', 'paypal_link', 'paypal_email', 'apple_pay', 'venmo', 'credit', 'zelle'])) {
                            session()->flash('success', 'Payment link successfully updated!');
                            return $this->redirect('/dashboard/button', navigate: true);
                        } else if (in_array($this->type, ['email', 'phone', 'sms', 'whatsapp', 'zalo', 'wechat', 'telegram', 'zoom', 'community', 'amazon_shop'])) {
                            session()->flash('success', 'Contact point successfully updated!');
                            return $this->redirect('/dashboard/button', navigate: true);
                        } else if ($this->type === 'link') {
                            session()->flash('success', 'Link successfully updated!');
                            return $this->redirect('/dashboard/button', navigate: true);
                        } else if (in_array($this->type, ['google_map', 'apple_map', 'waze'])) {
                            session()->flash('success', 'Direction link successfully added!');
                            return $this->redirect('/dashboard/directions', navigate: true);
                        }
                    }
                } else {
                    session()->flash('success', 'Link successfully updated!');
                    return $this->redirect('/dashboard/button', navigate: true);
                }
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }
    }

    public function render()
    {
        return view('components.button-edit-action-sheet');
    }
}
