<?php

namespace App\Livewire;

use App\Models\Button;
use App\Models\Member;
use App\Models\SubCard;
use App\Models\User;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use Illuminate\Support\Facades\DB;
use Livewire\WithPagination;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class AllTeamsPage extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $members;
    public $added;
    public $submission;

    public $user_type;

    public $user;
    public $checkifactive;
    public $page_id, $teams_count; //subcard id, used in query

    public function getMembers()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first();
            // $networkCondition = ['members.user_id' => auth()->user()->id];
            $condition = ['user_id' => auth()->user()->id];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->user = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->first();;
            // $networkCondition = ['members.page_id' => $this->page_id];
            $condition = ['page_id' => $this->page_id];
        }

        $this->teams_count = Button::where($condition)
            ->where('type', 'team')
            ->count();

        $this->user_type = auth()->user()->user_type;
    }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->getMembers();
    }

    public function render()
    {
        $this->authorize('view', Member::class);
        return view('livewire.all-teams-page')
            ->title('Members | ' . $this->site_name)->layoutData([
                'thumbnail' => $this->thumbnail,
                'app_name' => $this->app_name,
            ]);
    }
}
