<?php

namespace App\Livewire;

use App\Models\Analytics;
use App\Models\Button;
use App\Models\SubCard;
use App\Models\User;
use App\Models\Image;
use App\Models\Event;
use App\Models\Replay;
use App\Models\TrustedNetwork;
use App\Models\Member;
use App\Models\Review;
use App\Models\PresentationPage;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\ProductCollection;
use App\Models\Sale;
use App\Settings\CardDefaultsSetting;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Carbon\Carbon;
use Livewire\Component;
use App\Models\LeadCaptureForm;

class AllLinksPage extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;
    public $replays_functionality;

    public $user;
    public $social_count;
    public $button_count;
    public $product_count;
    public $subscription_count;
    public $product_collections_count;
    public $product_categories_count;
    public $video_count;
    public $images_count;
    public $contact_count;
    public $payment_count;
    public $services_count;
    public $events_count;
    public $sales_page_count;
    public $team_count, $trusted_network_count;
    public $direction_count;
    public $communities_count;
    public $pages_count;
    public $replays_count;
    public $forms_count;
    public $reviews_count;

    public $months;
    public $days;

    public $condition;
    // public $maincard_active; //used to determine which card is active
    public $page_id; //subcard id, used in query

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name                = $default->site_name;
        $this->thumbnail                = $default->thumbnail;
        $this->app_name                 = $default->app_name;
        $this->replays_functionality    = $default->replays_functionality;

        $this->showAnalytics();
    }

    public function showAnalytics()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();
        // if active, get the datas and set to form
        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)
                ->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'user_type', 'id', 'active_card']);

            $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];
        } else {

            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'users.firstname',
                    'users.lastname',
                    'users.user_type',
                    'users.active_card',
                ]);

            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->replays_count = Replay::where($this->condition)
            ->count();

        $this->forms_count = LeadCaptureForm::where($this->condition)
            ->count();

        $this->reviews_count = Review::where($this->condition)
            ->count();

        $this->social_count = auth()->user()
            ->socials()
            ->where($this->condition)
            ->count();

        $this->button_count = auth()->user()
            ->buttons()
            ->where('view', 'links')
            ->when(!in_array($this->user->user_type, ['Platinum']), fn($q) => $q->whereNot('type', 'trusted_network'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'reviews'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'zoom_replay'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'team'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'services'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'shop'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'bio'))
            ->when(!in_array($this->user->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'events'))
            ->where($this->condition)
            ->count();

        $this->product_count = Product::where($this->condition)->whereNot('type', 'subscription')->count();

        $this->subscription_count = Product::where($this->condition)->where('type', 'subscription')->count();

        $this->product_collections_count = ProductCollection::where($this->condition)->count();
        $this->product_categories_count = ProductCategory::where($this->condition)->count();

        $this->services_count = auth()->user()
            ->services()
            ->where($this->condition)
            ->count();

        if (auth()->user()->user_type == 'Basic') {
            $this->video_count = auth()->user()->videos()
                ->where($this->condition)
                ->limit(1)
                ->get()
                ->count();
        } else {
            $this->video_count = auth()->user()->videos()
                ->where($this->condition)
                ->count();
        }

        $this->images_count = Image::where($this->condition)
            ->count();

        $this->contact_count = auth()->user()
            ->buttons()
            ->where('view', 'contacts')
            ->where($this->condition)
            ->count();

        $this->direction_count = auth()->user()
            ->directions()
            ->where($this->condition)
            ->count();

        $this->communities_count = auth()->user()
            ->buttons()
            ->where('view', 'communities')
            ->where($this->condition)
            ->count();

        $this->pages_count = PresentationPage::where($this->condition)
            ->count();

        $this->payment_count = auth()->user()
            ->buttons()
            ->where('view', 'payments')
            ->where($this->condition)
            ->count();

        $this->events_count = Event::where($this->condition)
            ->count();

        $this->sales_page_count = Sale::where($this->condition)
            ->count();

        $this->team_count = Button::where($this->condition)
            ->where('type', 'team')
            ->count();

        //  $this->member_count = Member::where($this->condition)
        // ->count();

        $this->trusted_network_count = TrustedNetwork::where($this->condition)
            ->count();
    }

    public function render()
    {
        // dd($this->user->user_type, $this->user->active_card);
        $this->authorize('view', Analytics::class);
        return view('livewire.all-links-page', [
            'user' => $this->user,
        ])->title('All Links | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
