<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use App\Models\TrustedNetwork;
use App\Models\SubCard;

class AddToTrustedNetworkIcon extends Component
{
    public $page_id;
    public $checkifactive;
    public $bookmarked;
    public $username;
    public $user_id;
    public $member;
    public $card_type;
    public $condition;
    public $the_network;

    public function saveMember()
    {
        TrustedNetwork::create([
            'user_id'       => $this->checkifactive > 0 ? auth()->user()->id : null,
            'page_id'       => $this->checkifactive < 1 ? $this->page_id : null,
            'member_id'     => $this->member,
            'card_type'     => $this->card_type,
            'is_accepted'   => true
        ]);
    }

    public function deleteMember()
    {
        if ($this->member) {
            TrustedNetwork::where('member_id', $this->member)
                ->where($this->condition)
                ->delete();
        }
    }

    public function addMember($username)
    {
        $this->username = $username;

        if ($this->bookmarked) {
            $this->deleteMember();
            $this->bookmarked = false;
        } else {
            $this->saveMember();
            $this->bookmarked = true;
        }
    }

    public function mount($username)
    {
        $this->username = $username;

        //check if current card is a main card or subcard
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->member = User::where('username', $username)
            ->where('is_active', true)->pluck('id')->first();
        $this->card_type = 'main';

        // if member is main card
        if ($this->member) {
            if ($this->checkifactive > 0) {
                // if user main card is used, check if member main card is recorded
                $is_bookmarked = TrustedNetwork::join('users', 'trusted_network.member_id', '=', 'users.id')
                    ->where('users.username', $username)
                    ->when(isset($this->condition['user_id']), fn($q) => $q->where('trusted_network.user_id', $this->condition['user_id']))
                    ->when(isset($this->condition['page_id']), fn($q) => $q->where('trusted_network.page_id', $this->condition['page_id']))
                    ->where('trusted_network.card_type', 'main')
                    ->pluck('trusted_network.member_id')->first();
            } else {
                // if user sub card is used, check if member main card is recorded
                $is_bookmarked = TrustedNetwork::join('users', 'trusted_network.member_id', '=', 'users.id')
                    ->where('users.username', $username)
                    ->when(isset($this->condition['user_id']), fn($q) => $q->where('trusted_network.user_id', $this->condition['user_id']))
                    ->when(isset($this->condition['page_id']), fn($q) => $q->where('trusted_network.page_id', $this->condition['page_id']))
                    ->where('trusted_network.card_type', 'main')
                    ->pluck('trusted_network.member_id')->first();
            }
        }
        // if member is sub card
        else {
            $this->member = SubCard::where('username', $username)
                ->where('is_active', true)->pluck('id')->first();
            $this->card_type = 'sub';

            if ($this->checkifactive > 0) {
                $is_bookmarked = TrustedNetwork::join('subcards', 'trusted_network.member_id', '=', 'subcards.id')
                    ->where('subcards.username', $username)
                    ->when(isset($this->condition['user_id']), fn($q) => $q->where('trusted_network.user_id', $this->condition['user_id']))
                    ->when(isset($this->condition['page_id']), fn($q) => $q->where('trusted_network.page_id', $this->condition['page_id']))
                    ->where('trusted_network.card_type', 'sub')
                    ->pluck('trusted_network.member_id')->first();
            } else {
                $is_bookmarked = TrustedNetwork::join('subcards', 'trusted_network.member_id', '=', 'subcards.id')
                    ->where('subcards.username', $username)
                    ->when(isset($this->condition['user_id']), fn($q) => $q->where('trusted_network.user_id', $this->condition['user_id']))
                    ->when(isset($this->condition['page_id']), fn($q) => $q->where('trusted_network.page_id', $this->condition['page_id']))
                    ->where('trusted_network.card_type', 'sub')
                    ->pluck('trusted_network.member_id')->first();
            }
        }

        $this->the_network = $is_bookmarked;
        if ($is_bookmarked) {
            $this->bookmarked = true;
        } else {
            $this->bookmarked = false;
        }
    }

    public function render()
    {
        return view('livewire.add-to-trusted-network-icon');
    }
}
