<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use App\Models\Member;
use App\Models\SubCard;
use App\Settings\CardDefaultsSetting;

class AddToTeam extends Component
{
    public $page_id;
    public $checkifactive;
    public $bookmarked;
    public $username;
    public $team_id;
    public $member;
    public $card_type;
    public $query;

    public function saveMember()
    {
        // if ($this->checkifactive > 0) {

        //     $this->query = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        // } else {
        //     $user_id = SubCard::where('user_id', auth()->user()->id)
        //         ->where('active_card', true)
        //         ->pluck('id')
        //         ->first();
        //     $this->query = ['page_id' => $user_id];
        // }

        $save = Member::create([
            // ...$this->query,
            'member_id' => $this->member,
            'team_id' => $this->team_id,
            'card_type' => $this->card_type,
            // 'type' => 'saved',
        ]);

        // if ($save) {
        //     session()->flash('success', 'Team Member added!');
        // } else {
        //     session()->flash('error', 'Error adding to team.');
        // }

        // return $this->redirect('/' . $this->username, navigate: true);
    }

    public function deleteMember()
    {
        // check if member is existing and active
        if ($this->member) {
            // $delete = Member::where($this->query)
            //     ->where('member_id', $this->member)
            //     ->where('team_id', $this->team_id)
            //     ->delete();

            $delete = Member::where('member_id', $this->member)
                ->where('team_id', $this->team_id)
                ->delete();

            // if ($delete) {
            //     session()->flash('success', 'Team Member removed. It will now disappear on your team members tab.');
            // } else {
            //     session()->flash('error', 'Error removing team member.');
            // }
        }

        // return $this->redirect('/' . $this->username, navigate: true);
    }

    public function addMember($username, $team_id)
    {
        // Update the component properties with the button click values
        $this->username = $username;
        $this->team_id = $team_id;

        if ($this->bookmarked) {
            $this->deleteMember();
            $this->bookmarked = false;
        } else {
            $this->saveMember();
            $this->bookmarked = true;
        }
    }

    public function mount($username, $team_id)
    {
        $this->username = $username;
        $this->team_id = $team_id;

        // dd($this->username, $this->team_id);
        // check if member added is a main card or a subcard
        $this->member = User::where('username', $username)
            ->where('is_active', true)->pluck('id')->first();
        // dd($this->member);
        $this->card_type = 'main';

        //check if current card is a main card or subcard
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        // if subcard, get id
        $this->page_id = SubCard::where('user_id', auth()->user()->id)
            ->where('active_card', true)
            ->pluck('id')
            ->first();

        // if member is main card
        if ($this->member) {
            if ($this->checkifactive > 0) {
                // if user main card is used, check if member main card is recorded
                $is_bookmarked = Member::join('users', 'members.member_id', '=', 'users.id')
                    ->where('users.username', $username)
                    ->where('members.team_id', $this->team_id)
                    // ->where('members.user_id', auth()->user()->id)
                    ->where('members.card_type', 'main')
                    ->pluck('members.member_id')->first();
            } else {
                // if user sub card is used, check if member main card is recorded
                $is_bookmarked = Member::join('users', 'members.member_id', '=', 'users.id')
                    ->where('users.username', $username)
                    ->where('members.team_id', $this->team_id)
                    // ->where('members.page_id', $this->page_id)
                    ->where('members.card_type', 'main')
                    ->pluck('members.member_id')->first();
            }
        }
        // if member is sub card
        else {
            $this->member = SubCard::where('username', $username)
                ->where('is_active', true)->pluck('id')->first();
            $this->card_type = 'sub';

            if ($this->checkifactive > 0) {
                $is_bookmarked = Member::join('subcards', 'members.member_id', '=', 'subcards.id')
                    ->where('subcards.username', $username)
                    // ->where('members.user_id', auth()->user()->id)
                    ->where('members.card_type', 'sub')
                    ->pluck('members.member_id')->first();
            } else {
                $is_bookmarked = Member::join('subcards', 'members.member_id', '=', 'subcards.id')
                    ->where('subcards.username', $username)
                    // ->where('members.page_id', $this->page_id)
                    ->where('members.card_type', 'sub')
                    ->pluck('members.member_id')->first();
            }
        }

        if ($is_bookmarked) {
            $this->bookmarked = true;
        } else {
            $this->bookmarked = false;
        }
    }

    public function render()
    {
        return view('livewire.add-to-team');
    }
}
