<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Sale;
use App\Models\SaleVideo;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;

class AddSalesVideo extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;

    public $product_name, $description, $stock = 1, $price, $video_link, $shop_online_link;
    public $is_active = true;
    public $shop_online_button = "Shop Online";
    public $sales_id;
    // public $page_id; //subcard id, used in query

    public function toggleActive()
    {
        $this->is_active = !$this->is_active;
    }

    public function saveVideo()
    {
        $validated = $this->validate([
            'product_name'          => 'required|string|max:100',
            'description'           => 'nullable|string|max:300',
            'stock'                 => 'required|numeric',
            'price'                 => 'required|numeric',
            'video_link'            => 'required|url',
            'shop_online_button'    => 'nullable|string',
            'shop_online_link'      => 'required|url',
            'is_active'             => 'required|boolean',
        ]);

        if (!$this->shop_online_button) {
            $validated['shop_online_button'] = 'Shop';
        }

        $validated['sales_id'] = $this->sales_id;

        $addSalesPage = SaleVideo::create($validated);

        if ($addSalesPage) {
            session()->flash('success', 'Video successfully added!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/sales/edit/' . $this->sales_id, navigate: true);
        // return $this->redirect(request()->header('Referer'), navigate: true);
    }

    public function mount(Sale $sales)
    {
        $this->sales_id = $sales->id;
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;

        $this->authorize('create', SaleVideo::class);
        return view('livewire.add-sales-video')->title('Add Video | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
        ]);
    }
}
