<?php

namespace App\Livewire;

use App\Models\Review;
use Livewire\Component;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use Illuminate\Validation\ValidationException;

class AddReviewVideos extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $title, $video_link, $review_text, $cta_text, $cta_link;

    public $page_id; //subcard id, used in query

    public function saveTestimonial()
    {
        try {
            $validated = $this->validate([
                'title'             => 'required|string',
                'video_link'        => 'required|url',
                'review_text'       => 'nullable|string|max:2000',
                'cta_text'          => 'nullable|string',
                'cta_link'          => 'nullable|url',
            ]);

            $validated['user_id'] = auth()->user()->id;

            $checkifactive = User::where('id', auth()->user()->id)
                ->where('active_card', true)->count();

            //if maincard is not active
            if ($checkifactive < 1) {
                $this->page_id = SubCard::where('user_id', auth()->user()->id)
                    ->where('active_card', true)
                    ->pluck('id')
                    ->first();
                $validated['page_id'] = $this->page_id;
            }

            $addVideo = Review::create($validated);

            if ($addVideo) {
                session()->flash('success', 'Testimonial video successfully added!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }

        return $this->redirect('/dashboard/testimonial', navigate: true);
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        // $this->authorize('create', Video::class);
        return view('livewire.add-review-videos')->title('Add Testimonial Video | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
