<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\SubCard;
use App\Models\User;
use App\Models\Product;
use App\Models\ProductMedia;
use App\Models\UserSettings;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use Livewire\WithFileUploads;

class AddProductImages extends Component
{
    use AuthorizesRequests;

    use WithFileUploads;
    public $images = [];
    public $tempImages = [];

    public $checkifactive, $images_count;
    public $to_upload_count = 10;
    public $condition, $check_if_product_is_from_user;
    public $product_id;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $color_settings_profile_pic_border;
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    public $page_id; //subcard id, used in query

    public $is_subscription;

    public function checkImages()
    {
        if (count($this->images) === 0) {
            $this->dispatch('no-images-left');
        } else {
            $this->dispatch('images-exist');
        }
    }

    public function removeTempImage($uniqueFileId)
    {
        // dd($uniqueFileId);
        foreach ($this->images as $index => $tempImage) {
            // dd($tempImage->getFilename(), $uniqueFileId);
            if ($tempImage->getFilename() === $uniqueFileId) {
                $tempFilePath = $tempImage->getRealPath();
                if (file_exists($tempFilePath)) {
                    unlink($tempFilePath);  // Delete the temporary file explicitly
                    unset($this->images[$index]);
                }
                break;
            }
        }
    }

    public function saveImages()
    {
        try {
            if (empty($this->images)) {
                session()->flash('info', 'Upload image(s) first before saving.');
                return $this->redirect('/product/edit/' . $this->product_id, navigate: true);
            }

            foreach ($this->images as $tempImage) {
                $imagePath = $tempImage->storePublicly('products', 'public');

                ProductMedia::create([
                    'product_id' => $this->product_id,
                    'path' => $imagePath,
                    'type' => 'image'
                ]);

                $tempFilePath = $tempImage->getRealPath();

                if (file_exists($tempFilePath)) {
                    unlink($tempFilePath);  // Delete the temporary file explicitly
                }
            }

            $this->images = [];
            session()->flash('success', 'Product gallery successfully updated!');
            // return $this->redirect('/product/edit/' . $this->product_id, navigate: true);

            if ($this->is_subscription) {
                return $this->redirect('/subscriptions/edit/' . $this->product_id, navigate: true);
            } else {
                return $this->redirect('/product/edit/' . $this->product_id, navigate: true);
            }
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
            // session()->flash('error', 'The file must be an image (jpeg, png, jpg, heic, heif or webp).');
        }
    }

    public function mount($product_id)
    {
        $this->product_id;

        $this->is_subscription = Product::where('id', $product_id)
            ->value('type') === 'subscription';

        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive < 1) {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        } else {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        }
        $this->images_count = ProductMedia::where('product_id', $this->product_id)->where('type', 'image')->count();
        $this->to_upload_count = $this->to_upload_count - $this->images_count;
        // dd($this->to_upload_count);

        $this->check_if_product_is_from_user = Product::where('id', $product_id)
            ->where($this->condition)->count();

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // dd($check_if_product_is_from_user);

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';

        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';

        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        // $this->authorize('create', Image::class);
        return view('livewire.add-product-images')->title('Add Product Images | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'color_settings_profile_pic_border' => $this->color_settings_profile_pic_border,
            'color_settings_custom_button_text' => $this->color_settings_custom_button_text,
            'color_settings_custom_button' => $this->color_settings_custom_button,
            'app_name' => $this->app_name,
        ]);
    }
}
