<?php

namespace App\Livewire;

use App\Models\User;
use Livewire\Component;
use Livewire\Attributes\Title;
use Illuminate\Support\Facades\Auth;
use App\Settings\CardDefaultsSetting;
use App\Helpers\SavingLinkHelpers;
use App\Models\SubCard;
use Livewire\Attributes\On;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use App\Models\LetsConnect;
use App\Models\Network;

class AddNetworkManually extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    // public $user;
    // public $user_type;
    // public $user_type_get;
    // public $firstname;
    // public $lastname;
    // public $job_title;
    // public $company;
    // public $country;
    // public $company_website;
    // public $note;
    // public $phone;

    // public $maincard_active; //used to determine which card is active

    public $page_id, $checkifactive;

    public $username, $firstname, $lastname, $phone, $gender, $profile_pic, $job_title, $we_met_at, $company, $company_website, $country, $email;

    // public function viewProfile()
    // {
    //     // Check if main card is active
    //     $checkifactive = User::where('id', Auth::user()->id)
    //         ->where('active_card', true)->count();
    //     // if active, get the datas and set to form
    //     if ($checkifactive > 0) {
    //         $this->maincard_active = true;
    //         $this->user = User::where('id', Auth::user()->id)
    //             ->select('id', 'username', 'firstname', 'lastname', 'phone', 'job_title', 'bio', 'bio_long', 'company', 'company_website', 'user_type', 'country')
    //             ->first();

    //         $this->user_type_get = $this->user->user_type;
    //     } else {
    //         // if main card is not active, get the infos from subcard
    //         $this->maincard_active = false;
    //         $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
    //             ->where('subcards.user_id', auth()->user()->id)
    //             ->where('subcards.active_card', true)
    //             ->select(
    //                 'subcards.id',
    //                 'subcards.username',
    //                 'subcards.firstname',
    //                 'subcards.lastname',
    //                 'subcards.phone',
    //                 'subcards.job_title',
    //                 'subcards.bio',
    //                 'subcards.bio_long',
    //                 'subcards.company',
    //                 'subcards.company_website',
    //                 'users.user_type',
    //             )->first();

    //         $this->user_type_get = $this->user->user_type;
    //         $this->page_id = $this->user->id;
    //     }
    // }

    #[On('profilePic')]
    public function setProfilePic($profileImageUrl)
    {
        $this->profile_pic = new TemporaryUploadedFile($profileImageUrl, config('filesystems.default'));
    }

    public function addtoNetworkManually()
    {
        $validated = $this->validate(
            [
                'firstname' => 'required|string|max:50',
                'lastname' => 'required|string|max:50',
                'phone' => 'required|regex:/^\d+$/|max:20',
                'gender' => 'required|in:Male,Female',
                'profile_pic' => 'nullable|image|mimes:jpeg,jpg,png,webp|max:5120',
                'job_title' => 'required|string|max:200',
                'we_met_at' => 'nullable|string|max:200',
                'company' => 'nullable|string|max:255',
                'company_website' => 'nullable|string|max:255',
                'country' => 'required|string',
                'email' => 'required|email:filter',
            ],
            //Custom error messages
            [
                'phone.regex' => 'The phone may only contain numbers.',
            ]
        );

        if ($this->profile_pic) {
            $validated['profile_pic'] =  $this->profile_pic->storePublicly('profile_pic', 'public');

            // Get the path of the temporary file (before it's stored in the public directory)
            $tempFilePath = $this->profile_pic->getRealPath();

            if (file_exists($tempFilePath)) {
                unlink($tempFilePath);  // Delete the temporary file explicitly
            }
        }

        try {

            $validated['type'] = 'added';

            if ($this->checkifactive > 0) {
                $create = LetsConnect::create([
                    'user_id' => auth()->user()->id,
                    'page_id' => NULL,
                    'firstname' => $validated['firstname'],
                    'lastname' => $validated['lastname'],
                    'phone' => $validated['phone'],
                    'gender' => $validated['gender'],
                    'profile_pic' => $validated['profile_pic'],
                    'job_title' => $validated['job_title'],
                    'we_met_at' => $validated['we_met_at'],
                    'company' => $validated['company'],
                    'company_website' => $validated['company_website'],
                    'country' => $validated['country'],
                    'email' => $validated['email'],
                    'type' => $validated['type'],
                ]);

                Network::create([
                    'user_id' => auth()->user()->id,
                    'page_id' => NULL,
                    'network_id' => $create->id,
                    'type' => 'added',
                ]);
            } else {
                $create = LetsConnect::create([
                    'user_id' => NULL,
                    'page_id' => $this->page_id,
                    'firstname' => $validated['firstname'],
                    'lastname' => $validated['lastname'],
                    'phone' => $validated['phone'],
                    'gender' => $validated['gender'],
                    'profile_pic' => $validated['profile_pic'],
                    'job_title' => $validated['job_title'],
                    'we_met_at' => $validated['we_met_at'],
                    'company' => $validated['company'],
                    'company_website' => $validated['company_website'],
                    'country' => $validated['country'],
                    'email' => $validated['email'],
                    'type' => $validated['type'],
                ]);

                Network::create([
                    'user_id' => auth()->user()->id,
                    'page_id' => $this->page_id,
                    'network_id' => $create->id,
                    'type' => 'added',
                ]);
            }

            if ($create) {
                session()->flash('success', 'Contact added successfully. It will now appear on your network tab.');
                return $this->redirect('/dashboard/network', navigate: true);
            } else {
                session()->flash('error', 'Error saving contact manually.');
            }
        } catch (\Exception $e) {
            session()->flash('company_website', $e->getMessage());
        }
    }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_url = $default->site_url;
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive < 1) {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
        }
        // this is used to set the old values of the fields
        // $this->viewProfile();

        // Initialize the properties with current user data
        // $user = Auth::user();

        // $this->username = $this->user->username;
        // $this->firstname = $this->user->firstname;
        // $this->lastname = $this->user->lastname;
        // $this->phone = $this->user->phone;
        // $this->job_title = $this->user->job_title;
        // $this->bio = $this->user->bio;
        // $this->bio_long = $this->user->bio_long;
        // $this->user_type = $this->user_type_get;
        // $this->company = $this->user->company;
        // $this->country = $this->user->country;
        // $this->company_website = $this->user->company_website;
    }

    public function render()
    {
        return view('livewire.add-network-manually')
            ->title('Add Network | ' . $this->site_name)->layoutData([
                'thumbnail' => $this->thumbnail,
                'app_name' => $this->app_name,
            ]);
    }
}
