<?php

namespace App\Livewire;

use App\Models\Direction;
use App\Models\User;
use App\Models\SubCard;
use Livewire\Component;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use Illuminate\Validation\ValidationException;

class AddDirectionLink extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $address, $google_map, $apple_map, $waze, $page_id;

    public function saveDirectionLink()
    {
        try {
            $validated = $this->validate([
                'address' => 'required|string',
                'google_map' => 'nullable|url',
                'apple_map' => 'nullable|url',
                'waze' => 'nullable|url',
            ]);

            $validated['user_id'] = auth()->user()->id;
            $validated['is_active'] = true;

            $checkifactive = User::where('id', auth()->user()->id)
                ->where('active_card', true)->count();

            //if maincard is not active
            if ($checkifactive < 1) {
                $this->page_id = SubCard::where('user_id', auth()->user()->id)
                    ->where('active_card', true)
                    ->pluck('id')
                    ->first();
                $validated['page_id'] = $this->page_id;
            }

            try {
                $addDirectionLink = Direction::create($validated);
            } catch (\Exception $e) {
                session()->flash('error', $e->getMessage());
                return redirect()->back();
            }

            if ($addDirectionLink) {
                session()->flash('success', 'Direction link successfully added!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }

            return $this->redirect('/dashboard/directions', navigate: true);
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        // $this->authorize('create', Button::class);
        return view('livewire.add-direction-link')->title('Add Direction Link | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
