<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class AdImageField extends Component
{
    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif,heic,avif|max:5120')]
    public $image;

    public ?string $croppedBlob;

    public $ad_image;

    #[On('setAdImage')]
    public function setAdImage($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
    }

    #[On('setEditAdImage')]
    public function setAdImageEdit($ad_image)
    {
        $this->ad_image = $ad_image;
    }

    public function render()
    {
        return view('livewire.ad-image-field');
    }
}
