<?php

namespace App\Jobs;

use App\Settings\CardDefaultsSetting;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SyncUserSubscriptionType
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected User $user;

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    public function handle(): void
    {
        $default = app(CardDefaultsSetting::class);
        $is_test_mode = $default->test_mode;

        // Basic
        $basic_yearly = $is_test_mode ? $default->test_basic_yearly : $default->live_basic_yearly;
        $basic_monthly = $is_test_mode ? $default->test_basic_monthly : $default->live_basic_monthly;

        // Gold
        $gold_yearly = $is_test_mode ? $default->test_gold_yearly : $default->live_gold_yearly;
        $gold_monthly = $is_test_mode ? $default->test_gold_monthly : $default->live_gold_monthly;

        // Platinum
        $platinum_yearly = $is_test_mode ? $default->test_platinum_yearly : $default->live_platinum_yearly;
        $platinum_monthly = $is_test_mode ? $default->test_platinum_monthly : $default->live_platinum_monthly;

        // Get active subscription price ID from Stripe
        $stripeSubscription = $this->user->subscription()?->asStripeSubscription();

        if (! $stripeSubscription || ! isset($stripeSubscription->items->data[0]->price->id)) {
            return; // no active subscription or price info
        }

        $price_id = $stripeSubscription->items->data[0]->price->id;

        // Match price_id to user type
        $new_type = match (true) {
            $price_id === $basic_yearly || $price_id === $basic_monthly     => 'Basic',
            $price_id === $gold_yearly  || $price_id === $gold_monthly      => 'Gold',
            $price_id === $platinum_yearly || $price_id === $platinum_monthly => 'Platinum',
            default => null,
        };

        // if ($new_type && $this->user->user_type !== $new_type) {
        //     $this->user->update(['user_type' => $new_type]);
        // }

        if ($new_type && $this->user->user_type !== $new_type) {
            $updates = ['user_type' => $new_type];

            if (in_array($new_type, ['Free', 'Basic'])) {
                $updates['partnership_level'] = null;
            }

            $this->user->update($updates);
        }
    }
}
