<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CanManageNetwork
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->user() && !in_array(auth()->user()->user_type, ['Influencer', 'Sponsored', 'Basic', 'Gold', 'Platinum'])) {
            abort(403);
        }

        return $next($request);
    }
}
