<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Settings\CardDefaultsSetting;

class UpgradeCheckoutController
{
    public $basic_yearly;
    public $basic_monthly;
    public $gold_yearly;
    public $gold_monthly;
    public $platinum_yearly;
    public $platinum_monthly;
    public $is_test_mode;
    public $app_name;
    public $free_trial_duration;
    public $free_trial_enabled;
    public function __invoke(Request $request)
    {
        $default = app(CardDefaultsSetting::class);

        $this->is_test_mode = $default->test_mode;
        $this->app_name = $default->app_name;
        $this->free_trial_duration = $default->free_trial_duration;
        $this->free_trial_enabled = $default->free_trial_enabled; // ✅ Pick correct price IDs (test vs live)
        $this->basic_yearly = $this->is_test_mode ? $default->test_basic_yearly : $default->live_basic_yearly;
        $this->basic_monthly = $this->is_test_mode ? $default->test_basic_monthly : $default->live_basic_monthly;
        $this->gold_yearly = $this->is_test_mode ? $default->test_gold_yearly : $default->live_gold_yearly;
        $this->gold_monthly = $this->is_test_mode ? $default->test_gold_monthly : $default->live_gold_monthly;
        $this->platinum_yearly = $this->is_test_mode ? $default->test_platinum_yearly : $default->live_platinum_yearly;
        $this->platinum_monthly = $this->is_test_mode ? $default->test_platinum_monthly : $default->live_platinum_monthly; // ✅ Validate incoming plan
        $validated = validator($request->query(), ['selected_plan' => 'required|in:basic,gold,platinum,basic_m,gold_m,platinum_m',])->validate();

        $selected_plan = $validated['selected_plan']; // ✅ Resolve price ID
        // dd($selected_plan);
        $price_id = match ($selected_plan) {
            'basic' => $this->basic_yearly,
            'basic_m' => $this->basic_monthly,
            'gold' => $this->gold_yearly,
            'gold_m' => $this->gold_monthly,
            'platinum' => $this->platinum_yearly,
            'platinum_m' => $this->platinum_monthly,
            default => abort(400, 'Invalid plan.'),
        };

        $user = $request->user();
        /** * ✅ CASE 1: User already has a subscription */ if ($user->subscribed('default')) {
            $subscription = $user->subscription('default'); // Still on trial & no payment method → open Checkout to collect card
            if ($subscription->onTrial() && !$user->hasDefaultPaymentMethod()) {
                return $user->newSubscription('default', $price_id)->checkout(['success_url' => route('upgrade.success'), 'cancel_url' => route('upgrade.index'), 'subscription_data' => ['metadata' => ['user_id' => $user->id, 'plan' => $selected_plan, 'app' => $this->app_name,],],]);
            } // Otherwise, swap plan and invoice immediately (paid upgrade)
            $subscription->swapAndInvoice($price_id);
            return redirect()->route('upgrade.success');
        }

        /** * ✅ CASE 2: User has NO active subscription */ $subscriptionBuilder = $user->newSubscription('default', $price_id); // Add a free trial only for new users and if feature is enabled
        if ($this->free_trial_enabled && !$user->subscriptions()->exists()) {
            if (in_array($selected_plan, ['basic', 'basic_m'])) {
                $subscriptionBuilder->trialDays($this->free_trial_duration);
            }
        }
        return $subscriptionBuilder->checkout([
            'success_url' => route('upgrade.success'),
            'cancel_url' => route('upgrade.index'),
            'subscription_data' =>
            ['metadata' => ['user_id' => $user->id, 'plan' => $selected_plan, 'app' => $this->app_name,],],
        ]);
    }
}
