<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use App\Settings\CardDefaultsSetting;

class CheckoutController
{
    public $basic_yearly;
    public $basic_monthly;

    public $gold_yearly;
    public $gold_monthly;

    public $platinum_yearly;
    public $platinum_monthly;

    public $is_test_mode;
    public $app_name;
    public $free_trial_duration;
    public $free_trial_enabled;

    public function __invoke(Request $request)
    {
        $default = app(CardDefaultsSetting::class);
        $this->is_test_mode = $default->test_mode;
        $this->app_name = $default->app_name;
        $this->free_trial_duration = $default->free_trial_duration;
        $this->free_trial_enabled = $default->free_trial_enabled;

        // Basic
        $this->basic_yearly = $this->is_test_mode ? $default->test_basic_yearly : $default->live_basic_yearly;

        $this->basic_monthly = $this->is_test_mode ? $default->test_basic_monthly : $default->live_basic_monthly;

        // Gold
        $this->gold_yearly = $this->is_test_mode ? $default->test_gold_yearly : $default->live_gold_yearly;

        $this->gold_monthly = $this->is_test_mode ? $default->test_gold_monthly : $default->live_gold_monthly;

        // Platinum
        $this->platinum_yearly = $this->is_test_mode ? $default->test_platinum_yearly : $default->live_platinum_yearly;

        $this->platinum_monthly = $this->is_test_mode ? $default->test_platinum_monthly : $default->live_platinum_monthly;

        // if ($request->selected_plan === 'free') {
        //     return redirect()->route('registration.success', [
        //         'data' => Crypt::encrypt([
        //             'plan' => 'free',
        //             'user_id' => auth()->id(),
        //         ]),
        //     ]);
        // }

        $validated = validator($request->query(), [
            'selected_plan' => 'required|in:basic,gold,platinum,basic_m,gold_m,platinum_m',
        ])->validate();

        $selected_plan = $validated['selected_plan'];

        if ($selected_plan == 'basic') {
            $price_id = $this->basic_yearly;
        } elseif ($selected_plan == 'basic_m') {
            $price_id = $this->basic_monthly;
        } elseif ($selected_plan == 'gold') {
            $price_id =  $this->gold_yearly;
        } elseif ($selected_plan == 'gold_m') {
            $price_id =  $this->gold_monthly;
        } elseif ($selected_plan == 'platinum') {
            $price_id =  $this->platinum_yearly;
        } elseif ($selected_plan == 'platinum_m') {
            $price_id =  $this->platinum_monthly;
        } else {
            abort(400, 'Invalid plan.');
        }

        $subscriptionBuilder = $request->user()
            ->newSubscription('default', $price_id);

        if (in_array($selected_plan, ['basic', 'basic_m']) && $this->free_trial_enabled == true) {
            $subscriptionBuilder->trialDays($this->free_trial_duration);
        }

        return $subscriptionBuilder->checkout([
            'success_url' => route('registration.success'),
            'cancel_url' => route('plan.index'),
            'subscription_data' => [
                'metadata' => [
                    'user_id' => auth()->id(),
                    'plan' => $selected_plan,
                    'app' => $this->app_name, // optional for multi-site
                ],
            ],
        ]);
    }
}
