<?php

namespace App\Filament\Widgets;

use Carbon\Carbon;
use App\Models\User;
use Filament\Widgets\ChartWidget;
use Flowframe\Trend\Trend;
use Flowframe\Trend\TrendValue;

class NewUsersDailyOverview extends ChartWidget
{
    protected static ?string $heading = 'New users for the last 7 days';
    protected static string $color = 'success';
    protected static ?int $sort = 4;
    protected function getData(): array
    {
        $startDate = now()->subDays(6);
        $endDate = now();

        $data = Trend::query(User::where('is_active', true)->where('is_admin', false))
            ->between($startDate, $endDate)
            ->perDay()
            ->count();

        return [

            'datasets' => [
                [
                    'label' => 'Registered users for the last 7 days',
                    'data' => $data->map(fn(TrendValue $value) => $value->aggregate),
                ],
            ],
            'labels' => $data->map(fn(TrendValue $value) => Carbon::parse($value->date)->format('M d')),
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }
}
