<?php

namespace App\Filament\Widgets;

use App\Models\Ad;
use App\Models\User;
use App\Models\Button;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class AdminStatsOverview extends BaseWidget
{
    protected static ?int $sort = 1;

    protected function getHeading(): ?string
    {
        return 'Overview';
    }

    protected function getDescription(): ?string
    {
        return 'An overview of the analytics.';
    }

    public function redirectToAds()
    {
        return redirect('/admin/ads?tableFilters[is_active][isActive]=true&tableFilters[display_in][value]=Free');
    }

    public function redirectToSponsoredAds()
    {
        return redirect('/admin/ads?tableFilters[is_active][isActive]=true&tableFilters[display_in][value]=Sponsored');
    }

    public function redirectToClients()
    {
        return redirect('/admin/clients');
    }

    public function redirectToActiveClients()
    {
        return redirect('/admin/clients?tableFilters[is_active][isActive]=true');
    }

    protected function getStats(): array
    {
        return [
            Stat::make('Clients', User::whereIn('user_type', ['Free', 'Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored'])->where('is_admin', 0)->count())
                ->description('All existing clients')
                ->descriptionIcon('heroicon-m-arrow-up-right')
                ->color('success')
                // ->chart([2, 1, 20, 10, 100])
                ->color('success')
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => 'redirectToClients',
                ]),

            Stat::make('Active Users', User::where('is_active', 1)->where('is_admin', 0)->count())
                ->description('All active users')
                ->descriptionIcon('heroicon-m-arrow-up-right')
                ->color('success')
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => 'redirectToActiveClients',
                ]),

            Stat::make('Admin Ads', Ad::where('display_in', 'Free')->where('is_admin', true)->count())
                ->description('Total Admin Ads')
                ->descriptionIcon('heroicon-m-arrow-up-right')
                ->color('success')
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => 'redirectToAds',
                ]),

            Stat::make('Sponsor Ads', Ad::where('display_in', 'Sponsored')->where('is_admin', true)->count())
                ->description('Total Sponsor Ads')
                ->descriptionIcon('heroicon-m-arrow-up-right')
                ->color('success')
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => 'redirectToSponsoredAds',
                ]),
        ];
    }
}
