<?php

namespace App\Filament\Widgets;

use Carbon\Carbon;
use App\Models\User;
use Filament\Widgets\ChartWidget;
use Flowframe\Trend\Trend;
use Flowframe\Trend\TrendValue;

class AdminChartOverview extends ChartWidget
{
    protected static ?string $heading = 'New users for the last 6 months';
    protected static string $color = 'success';
    protected static ?int $sort = 3;
    protected function getData(): array
    {
        $data = Trend::query(User::where('is_active', true)->where('is_admin', false))
            ->between(
                start: now()->subMonths(5),
                end: now(),
            )
            ->perMonth()
            ->count();

        return [

            'datasets' => [
                [
                    'label' => 'Registered users per month',
                    'data' => $data->map(fn(TrendValue $value) => $value->aggregate),
                ],
            ],
            'labels' => $data->map(fn(TrendValue $value) => Carbon::parse($value->date)->format('M Y')),
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }
}
