<?php

namespace App\Filament\Resources;

use App\Filament\Resources\UpgradeRequestResource\Pages;
use App\Models\UpgradeRequest;
use App\Models\SubCard;
use App\Models\User;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Model;
use App\Settings\CardDefaultsSetting;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Infolist;
use Filament\Infolists\Components;
use Filament\Infolists\Components\ImageEntry;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\HtmlString;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;

class UpgradeRequestResource extends Resource
{
    protected static ?string $model = UpgradeRequest::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'Forms';

    protected static ?string $navigationLabel = 'Upgrade Requests';

    protected static ?string $modelLabel = 'Upgrade Request';

    protected static ?int $navigationSort = 4;

    public static function shouldRegisterNavigation(): bool
    {
        return app(CardDefaultsSetting::class)->manual_capture_mode === true;
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->modifyQueryUsing(
                fn(Builder $query) =>
                $query->orderBy('created_at', 'desc')
            )
            ->columns([

                Tables\Columns\TextColumn::make('old_plan')
                    ->badge()
                    ->label('Current Card')
                    ->formatStateUsing(function ($state) {
                        $settings = app(CardDefaultsSetting::class);

                        return match ($state) {
                            'Basic' => $settings->term_basic,
                            'Gold' => $settings->term_gold,
                            'Platinum' => $settings->term_platinum,
                            default => $state,
                        };
                    })
                    ->color(function ($state) {
                        return match ($state) {
                            'Free' => 'info',
                            'Basic' => 'success',
                            'Gold' => 'warning',
                            'Platinum' => 'gray',
                            'Sponsored' => 'danger',
                            'Influencer' => 'influencer',
                        };
                    }),

                Tables\Columns\TextColumn::make('plan')
                    ->badge()
                    ->label('Upgrade to')
                    ->formatStateUsing(function ($state) {
                        $settings = app(CardDefaultsSetting::class);

                        return match ($state) {
                            'basic' => $settings->term_basic,
                            'gold' => $settings->term_gold,
                            'platinum' => $settings->term_platinum,
                        };
                    })
                    ->color(function ($state) {
                        return match ($state) {
                            'basic' => 'success',
                            'gold' => 'warning',
                            'platinum' => 'gray',
                        };
                    }),


                Tables\Columns\TextColumn::make('user.firstname')
                    ->label('Client')
                    ->formatStateUsing(
                        fn($state, $record) =>
                        $record->user
                            ? "{$record->user->firstname} {$record->user->lastname}"
                            : 'N/A'
                    ),

                // Tables\Columns\TextColumn::make('user.email')
                //     ->label('Email')
                //     ->formatStateUsing(
                //         fn($state, $record) =>
                //         $record->user
                //             ? "{$record->user->email}"
                //             : 'N/A'
                //     ),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Date')
                    ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\Action::make('convert_to_card')
                //     ->label('Convert to Card')
                //     ->icon('heroicon-o-credit-card')
                //     ->color('success')
                //     ->requiresConfirmation()
                //     ->action(function ($record, $livewire) {

                //         $email = $record->email;

                //         // Check if email exists in Users or SubCards
                //         $existsInUsers = User::where('email', $email)->exists();
                //         $existsInSubCards = SubCard::where('email', $email)->exists();

                //         if ($existsInUsers || $existsInSubCards) {
                //             Notification::make()
                //                 ->title('Email already exists')
                //                 ->body("The email '{$email}' is already registered.")
                //                 ->danger()
                //                 ->send();
                //             return;
                //         }

                //         // Generate a unique username
                //         $username = strtolower(preg_replace('/\s+/', '', $record->firstname)) . '_' . uniqid();

                //         // Handle profile picture duplication if it exists
                //         $profilePicPath = $record->profile_pic;
                //         $newProfilePicPath = null;

                //         if ($profilePicPath && Storage::disk('public')->exists($profilePicPath)) {
                //             $filename = basename($profilePicPath);
                //             $newProfilePicPath = 'profile_pic/' . uniqid() . '_' . $filename;
                //             Storage::disk('public')->copy($profilePicPath, $newProfilePicPath);
                //         }

                //         // Create the new user
                //         $user = User::create([
                //             'firstname' => $record->firstname,
                //             'lastname' => $record->lastname,
                //             'email' => $record->email,
                //             'phone' => $record->phone,
                //             'username' => $username,
                //             'profile_pic' => $newProfilePicPath,
                //             'password' => bcrypt(app(CardDefaultsSetting::class)->default_password), // optional default password
                //         ]);

                //         Notification::make()
                //             ->title('Card successfully upgraded')
                //             ->body("User {$user->firstname} {$user->lastname} was upgraded successfully.")
                //             ->success()
                //             ->send();
                //     }),

                // Tables\Actions\DeleteAction::make(),
            ]);
        // ->bulkActions([
        //     Tables\Actions\BulkActionGroup::make([
        //         Tables\Actions\DeleteBulkAction::make(),
        //     ]),
        // ]);
    }

    public static function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Components\Section::make('Form Details')
                    ->schema([
                        ImageEntry::make('receipt')
                            ->label(new HtmlString('<strong>Receipt</strong>'))
                            ->square()
                            ->width('80%')
                            ->height('80%')
                            ->extraImgAttributes([
                                'alt' => 'Receipt',
                                'loading' => 'lazy',
                            ])
                            ->defaultImageUrl(asset('/img/product-placeholder.jpg')),

                        Components\Group::make([
                            TextEntry::make('user.firstname')
                                ->label(new HtmlString('<strong>Client</strong>'))
                                ->formatStateUsing(
                                    fn($state, $record) =>
                                    $record->user
                                        ? "{$record->user->firstname} {$record->user->lastname}"
                                        : 'N/A'
                                ),

                            TextEntry::make('user.email')
                                ->label(new HtmlString('<strong>Email</strong>'))
                                ->formatStateUsing(
                                    fn($state, $record) =>
                                    $record->user
                                        ? "{$record->user->email}"
                                        : 'N/A'
                                ),

                            TextEntry::make('created_at')
                                ->label(new HtmlString('<strong>Requested</strong>'))
                                ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),

                            TextEntry::make('old_plan')
                                ->label(new HtmlString('<strong>Card type before upgrading</strong>'))
                                ->badge()
                                ->formatStateUsing(function ($state) {
                                    $settings = app(CardDefaultsSetting::class);

                                    return match ($state) {
                                        'Basic' => $settings->term_basic,
                                        'Gold' => $settings->term_gold,
                                        'Platinum' => $settings->term_platinum,
                                        default => $state,
                                    };
                                })
                                ->color(function ($state) {
                                    return match ($state) {
                                        'Free' => 'info',
                                        'Basic' => 'success',
                                        'Gold' => 'warning',
                                        'Platinum' => 'gray',
                                        'Sponsored' => 'danger',
                                        'Influencer' => 'influencer',
                                    };
                                }),

                            TextEntry::make('plan')
                                ->label(new HtmlString('<strong>Upgrade card to</strong>'))
                                ->badge()
                                // ->formatStateUsing(fn($state) => ucfirst($state)),
                                ->formatStateUsing(function ($state) {
                                    $settings = app(CardDefaultsSetting::class);

                                    return match ($state) {
                                        'basic' => $settings->term_basic,
                                        'gold' => $settings->term_gold,
                                        'platinum' => $settings->term_platinum,
                                        default => $state,
                                    };
                                })
                                ->color(function ($state) {
                                    return match ($state) {
                                        'basic' => 'success',
                                        'gold' => 'warning',
                                        'platinum' => 'gray',
                                    };
                                }),

                        ]),
                    ])
                    ->columns(2),

            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUpgradeRequests::route('/'),
            'create' => Pages\CreateUpgradeRequest::route('/create'),
            'edit' => Pages\EditUpgradeRequest::route('/{record}/edit'),
            'view' => Pages\ViewUpgradeRequest::route('/{record}'),
        ];
    }
}
