<?php

namespace App\Filament\Resources\SubCardsResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Settings\CardDefaultsSetting;

class TeamsRelationManager extends RelationManager
{
    protected static string $relationship = 'buttons';
    protected static ?string $title = 'Teams';
    protected static ?string $modelLabel = 'Team';

    public function form(Form $form): Form
    {
        return $form
            ->schema([]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->modifyQueryUsing(
                fn(Builder $query, RelationManager $livewire) =>
                $query->where('type', 'team')->orderBy('order')
            )
            ->columns([
                Tables\Columns\ToggleColumn::make('is_active')
                    ->label('Active')
                    ->onColor('success') // ✅ green when active
                    ->offColor('danger'), // ❌ red when inactive

                Tables\Columns\TextColumn::make('title'),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\Action::make('customAction')
                    ->label('New Team') // Button text
                    ->url(route('filament.admin.resources.teams.create'))
            ])
            ->actions([
                Tables\Actions\Action::make('view_card')
                    ->label('View')
                    ->icon('heroicon-o-eye')
                    ->url(fn($record) => app(CardDefaultsSetting::class)->site_url . $record->subcard->username . '/team/' . $record->id)
                    ->openUrlInNewTab()
                    ->color('info'),
                Tables\Actions\Action::make('edit')
                    ->label('Edit')
                    ->url(fn($record) => route('filament.admin.resources.teams.edit', $record)),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }
}
