<?php

namespace App\Filament\Resources\SubCardsResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Database\Eloquent\Model;
use App\Settings\CardDefaultsSetting;
use Filament\Tables\Actions\Action;

class ReviewsRelationManager extends RelationManager
{
    protected static string $relationship = 'reviews';

    public static function canViewForRecord(Model $ownerRecord, string $pageClass): bool
    {
        return app(CardDefaultsSetting::class)->reviews_functionality === true;
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('title')
                    ->columnSpanFull()
                    ->required()
                    ->maxLength(255),

                Forms\Components\TextInput::make('video_link')
                    ->label('Video Link')
                    ->placeholder('Youtube, Vimeo, Instagram or Tiktok')
                    ->url()
                    ->required()
                    ->columnSpanFull()
                    ->maxLength(255),

                Forms\Components\Textarea::make('review_text')
                    ->label('Testimonial Text')
                    ->columnSpanFull(),

                Forms\Components\TextInput::make('cta_text')
                    ->label('Button Title')
                    ->placeholder('Optional')
                    ->maxLength(255),

                Forms\Components\TextInput::make('cta_link')
                    ->label('Button Link')
                    ->url()
                    ->placeholder('Optional')
                    ->maxLength(255),

                // Forms\Components\Toggle::make('is_active')
                //     ->columnSpanFull()
                //     ->label('Active')
                //     ->default(true),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('title')
            ->reorderRecordsTriggerAction(
                fn(Action $action, bool $isReordering) => $action
                    ->button()
                    ->label($isReordering ? 'Disable reordering' : 'Enable reordering'),
            )
            ->modifyQueryUsing(function (Builder $query, RelationManager $livewire) {
                $query->orderBy('order');
            })
            ->columns([
                Tables\Columns\ToggleColumn::make('is_active')
                    ->label('Active')
                    ->onColor('success')
                    ->offColor('danger'),

                Tables\Columns\TextColumn::make('title'),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make()
                    ->createAnother(false)
                    ->disabled(fn(RelationManager $livewire) => $livewire->ownerRecord->reviews()->count() >= 10),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }
}
