<?php

namespace App\Filament\Resources\SubCardsResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Notifications\Notification;
use Filament\Tables\Actions\Action;
use Filament\Support\Enums\IconPosition;
use App\Models\Button;
use Filament\Tables\Actions\CreateAction;
use Filament\Tables\Actions\EditAction;

class DirectionsRelationManager extends RelationManager
{
    protected static string $relationship = 'directions';

    protected static ?string $title = 'Direction';
    protected static ?string $modelLabel = 'Direction';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                // Forms\Components\Select::make('type')
                //     ->required()
                //     ->label('Link Type')
                //     ->reactive()
                //     ->afterStateUpdated(function ($state, callable $get, callable $set) {
                //         $titles = [
                //             'google_map' => 'Google Map',
                //             'apple_map' => 'Apple Map',
                //             'waze' => 'Waze',
                //         ];

                //         $set('title', $titles[$state] ?? '');
                //     })
                //     ->options([
                //         'google_map' => 'Google Map',
                //         'apple_map' => 'Apple Map',
                //         'waze' => 'Waze',
                //     ]),
                // Forms\Components\TextInput::make('title')
                //     ->required()
                //     ->maxLength(255),
                // Forms\Components\TextInput::make('link')
                //     ->columnSpanFull()
                //     ->required()
                //     ->maxLength(255),

                Forms\Components\Textarea::make('address')
                    ->columnSpanFull()
                    ->required(),
                Forms\Components\TextInput::make('google_map')
                    ->label('Google Map Link')
                    ->columnSpanFull()
                    ->url(),
                Forms\Components\TextInput::make('apple_map')
                    ->label('Apple Link')
                    ->columnSpanFull()
                    ->url(),
                Forms\Components\TextInput::make('waze')
                    ->label('Waze Link')
                    ->columnSpanFull()
                    ->url(),
                Forms\Components\Toggle::make('is_active')
                    ->columnSpanFull()
                    ->label('Active')
                    ->default(true)
                    ->required(),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->description('All links listed/added here will be displayed as a driving direction on the card.')
            ->reorderable('order')
            ->reorderRecordsTriggerAction(
                fn(Action $action, bool $isReordering) => $action
                    ->button()
                    ->label($isReordering ? 'Disable reordering' : 'Enable reordering'),
            )
            ->modifyQueryUsing(
                fn(Builder $query, RelationManager $livewire) =>
                $query->orderBy('order')
            )
            ->columns([
                Tables\Columns\ToggleColumn::make('is_active')
                    ->label('Active')
                    ->onColor('success') // ✅ green when active
                    ->offColor('danger'), // ❌ red when inactive

                Tables\Columns\TextColumn::make('address')
                    ->searchable(),

                // Tables\Columns\TextColumn::make('type')
                //     ->searchable()
                //     ->formatStateUsing(fn($state) => ucfirst($state)),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make()
                    ->createAnother(false)
                    ->before(function (CreateAction $action, $livewire) {
                        // Access form data from the action
                        $data = $action->getFormData();

                        // Validate and process the link
                        try {
                            // Assuming $data is the input data for button creation
                            // Button::handleLinkFormatting($data);
                            // Proceed to create the button if no issues
                            $livewire->ownerRecord->directions()->create($data);

                            Notification::make()
                                ->title('Success')
                                ->body('Direction link created successfully.')
                                ->success()  // Success notification style
                                ->send();

                            // Cancel the action after manual creation to prevent default action execution
                            $action->cancel();  // Prevent the default action (which would also try to create the button)

                            // Check if the user is on a free plan and has exceeded the button limit
                            // if ($livewire->ownerRecord->user_type == 'Free' && $livewire->ownerRecord->directions()->count() >= 4) {
                            //     Notification::make()
                            //         ->warning()
                            //         ->title('Free card holders can only add up to 4 direction links!')
                            //         ->persistent()
                            //         ->send();

                            //     // Cancel the action to prevent further processing
                            //     $action->cancel(); // This ensures that the action is canceled and no further action is executed
                            // } else {
                            //     // Proceed to create the button if no issues
                            //     $livewire->ownerRecord->directions()->create($data);

                            //     Notification::make()
                            //         ->title('Success')
                            //         ->body('Direction link created successfully.')
                            //         ->success()  // Success notification style
                            //         ->send();

                            //     // Cancel the action after manual creation to prevent default action execution
                            //     $action->cancel();  // Prevent the default action (which would also try to create the button)
                            // }
                        } catch (\InvalidArgumentException $e) {
                            Notification::make()
                                ->title('Validation Error')
                                ->body($e->getMessage())  // Show the exception message
                                ->danger()  // Set notification style to error
                                ->send();

                            // Cancel the action to prevent the model creation
                            $action->halt(); // Halt the action to prevent further processing
                        }
                    })

                    ->mutateFormDataUsing(function (array $data, RelationManager $livewire) {
                        $data['user_id'] = $livewire->ownerRecord->user_id;
                        $data['view'] = 'directions';
                        return $data;
                    }),
            ])
            ->actions([
                Tables\Actions\EditAction::make()->before(function (EditAction $action, $livewire) {
                    $data = $action->getFormData();
                    try {
                        // Button::handleLinkFormatting($data);

                        // Fetch the existing button to update
                        $button = $action->getRecord();

                        $button->update($data);

                        Notification::make()
                            ->title('Success')
                            ->body('Direction link has been updated successfully.')
                            ->success()
                            ->send();

                        $action->cancel();

                        // if ($livewire->ownerRecord->user_type == 'Free' && $livewire->ownerRecord->directions()->count() >= 4) {
                        //     Notification::make()
                        //         ->warning()
                        //         ->title('Free card holders can only add up to 4 direction links!')
                        //         ->persistent()
                        //         ->send();

                        //     $action->cancel();
                        // } else {
                        //     // $livewire->ownerRecord->directions()->create($data);
                        //     $button->update($data);

                        //     Notification::make()
                        //         ->title('Success')
                        //         ->body('Direction link has been updated successfully.')
                        //         ->success()
                        //         ->send();

                        //     $action->cancel();
                        // }
                    } catch (\InvalidArgumentException $e) {
                        Notification::make()
                            ->title('Validation Error')
                            ->body($e->getMessage())
                            ->danger()
                            ->send();

                        $action->halt();
                    }
                }),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }
}
