<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SubCardsResource\Pages;
use App\Filament\Resources\SubCardsResource\RelationManagers\AdRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\ButtonsRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\ContactsRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\PaymentRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\ProductsRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\ServicesRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\SocialsRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\VideosRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\ImagesRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\EventsRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\DirectionsRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\CommunitiesRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\CategoryRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\ProductCollectionRelationManager;
// use App\Filament\Resources\SubCardsResource\RelationManagers\SalesRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\TrustedNetworkRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\TeamsRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\PagesRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\ReplaysRelationManager;
use App\Filament\Resources\SubCardsResource\RelationManagers\ReviewsRelationManager;
use App\Models\SubCard;
use App\Models\Button;
use App\Models\ColorPreset;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Settings\CardDefaultsSetting;
use Filament\Forms\Components\FileUpload;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\HtmlString;
use Filament\Forms\Components\Select;
use App\Models\User;
use Filament\Notifications\Notification;
use Filament\Forms\Set;
use Carbon\Carbon;
use AmidEsfahani\FilamentTinyEditor\TinyEditor;
use Filament\Forms\Components\Tabs;
use Filament\Forms\Components\ColorPicker;
use Filament\Tables\Actions\Action;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Collection;
use Filament\Tables\Actions\BulkAction;
use App\Models\Social;
use Filament\Forms\Components\ViewField;
use Filament\Forms\Components\RichEditor;
use Malzariey\FilamentLexicalEditor\Enums\ToolbarItem;
use Malzariey\FilamentLexicalEditor\FilamentLexicalEditor;
use Kahusoftware\FilamentCkeditorField\CKEditor;

class SubCardsResource extends Resource
{
    protected static ?string $model = SubCard::class;
    protected static ?string $navigationIcon = 'heroicon-o-users';

    protected static ?string $navigationGroup = 'Client Management';

    protected static ?int $navigationSort = 2;

    protected static function getTableBulkActions(): array
    {
        return [
            Tables\Actions\DeleteBulkAction::make(),

            Tables\Actions\BulkAction::make('bulkEdit')
                ->label('Bulk Edit')
                ->icon('heroicon-o-pencil-square')
                ->form(function (Collection $records) {
                    return [
                        Forms\Components\CheckboxList::make('fields')
                            ->label('Select fields to edit')
                            ->options([
                                'job_title' => 'Job Title',
                                'company' => 'Company',
                                'company_website' => 'Company Website',
                                'is_active' => 'Account Active'

                            ])
                            ->reactive(), // makes it re-render when updated

                        Forms\Components\TextInput::make('job_title')
                            ->required()
                            ->maxLength(200)
                            ->default(null)
                            ->hidden(fn(callable $get) => ! in_array('job_title', $get('fields') ?? [])),

                        Forms\Components\TextInput::make('company')
                            ->maxLength(255)
                            ->default(null)
                            ->hidden(fn(callable $get) => ! in_array('company', $get('fields') ?? [])),

                        Forms\Components\TextInput::make('company_website')
                            ->maxLength(255)
                            ->url()
                            ->columnSpanFull()
                            ->default(null)
                            ->hidden(fn(callable $get) => ! in_array('company_website', $get('fields') ?? [])),

                        Forms\Components\Toggle::make('is_active')
                            ->label('Account Active')
                            ->default(true)
                            ->hidden(fn(callable $get) => ! in_array('is_active', $get('fields') ?? [])),
                    ];
                })
                ->modalButton('Save Changes')
                ->action(function (Collection $records, array $data): void {
                    $fields = $data['fields'] ?? [];

                    foreach ($records as $record) {
                        foreach ($fields as $field) {
                            if (!empty($data[$field])) {
                                $record->$field = $data[$field];
                            }
                        }
                        $record->save();
                        Notification::make()
                            ->title('Success')
                            ->body('Card successfully updated.')
                            ->success()
                            ->send();
                    }
                }),

            Tables\Actions\BulkAction::make('addButtons')
                ->label('Add Button(s)')
                ->icon('heroicon-o-plus-circle')
                ->form([
                    Forms\Components\Repeater::make('buttons')
                        ->label('Buttons')
                        ->schema([
                            Forms\Components\Select::make('type')
                                ->required()
                                ->label('Link Type')
                                ->options([
                                    'link'      => 'Link',
                                    'community' => 'Community',
                                    'email'     => 'Email',
                                    'phone'     => 'Phone',
                                    'sms'       => 'SMS',
                                    'whatsapp'  => 'WhatsApp',
                                    'telegram'  => 'Telegram',
                                ]),

                            Forms\Components\TextInput::make('title')
                                ->required()
                                ->maxLength(255),

                            Forms\Components\TextInput::make('link')
                                ->columnSpanFull()
                                ->required(),

                            Forms\Components\Toggle::make('is_active')
                                ->columnSpanFull()
                                ->label('Active')
                                ->default(true)
                                ->required(),
                        ])
                        ->minItems(1)
                        ->maxItems(10)
                        ->createItemButtonLabel('Add Another Button'),
                ])
                ->modalButton('Add Button(s)')
                ->action(function (Collection $records, array $data): void {
                    foreach ($records as $subcard) {
                        foreach ($data['buttons'] as $button) {
                            try {
                                // 🔎 Validate & format link (your custom logic)
                                Button::handleLinkFormatting($button);

                                $subcard->buttons()->create([
                                    'type'       => $button['type'],
                                    'title'      => $button['title'],
                                    'link'       => $button['link'] ?? null,
                                    'is_active'  => $button['is_active'] ?? true,
                                    'user_id'    => $subcard->user_id, // ensure consistency
                                    'view'       => 'links',
                                    'display_as' => 'button',
                                ]);

                                Notification::make()
                                    ->title('Buttons Added')
                                    ->body('New button(s) have been added to selected users (if valid).')
                                    ->success()
                                    ->send();
                            } catch (\InvalidArgumentException $e) {
                                Notification::make()
                                    ->title('Validation Error')
                                    ->body($e->getMessage())
                                    ->danger()
                                    ->send();
                            }
                        }
                    }
                }),

            Tables\Actions\BulkAction::make('addContacts')
                ->label('Add Contact(s)')
                ->icon('heroicon-o-plus-circle')
                ->form([
                    Forms\Components\Repeater::make('contacts')
                        ->label('Contacts')
                        ->schema([
                            Forms\Components\Select::make('type')
                                ->required()
                                ->label('Contact Type')
                                ->reactive()
                                ->afterStateUpdated(function ($state, callable $set) {
                                    $titles = [
                                        'email'     => 'Email',
                                        'phone'     => 'Phone',
                                        'sms'       => 'SMS/Text',
                                        'whatsapp'  => 'WhatsApp',
                                        'telegram'  => 'Telegram',
                                        'zoom'      => 'Zoom',
                                        'community' => 'Community',
                                    ];
                                    $set('title', $titles[$state] ?? '');
                                })
                                ->options([
                                    'email'     => 'Email',
                                    'phone'     => 'Phone',
                                    'sms'       => 'SMS/Text',
                                    'whatsapp'  => 'WhatsApp',
                                    'telegram'  => 'Telegram',
                                    'zoom'      => 'Zoom',
                                    'community' => 'Community',
                                ]),

                            Forms\Components\TextInput::make('title')
                                ->required()
                                ->maxLength(255),

                            Forms\Components\TextInput::make('link')
                                ->columnSpanFull()
                                ->required()
                                ->maxLength(255),

                            Forms\Components\Toggle::make('is_active')
                                ->columnSpanFull()
                                ->label('Active')
                                ->default(true)
                                ->required(),
                        ])
                        ->minItems(1)
                        ->maxItems(10)
                        ->createItemButtonLabel('Add Another Contact'),
                ])
                ->modalButton('Add Contact(s)')
                ->action(function (\Illuminate\Support\Collection $records, array $data): void {
                    foreach ($records as $subcard) {
                        foreach ($data['contacts'] as $contact) {
                            try {
                                // Run your validation / formatting
                                Button::handleLinkFormatting($contact);

                                // Enforce Free-plan contact limit (check parent user)
                                if (
                                    $subcard->user->user_type === 'Free'
                                    && $subcard->buttons()->where('view', 'contacts')->count() >= 4
                                ) {
                                    Notification::make()
                                        ->warning()
                                        ->title('Free card holders can only add up to 4 contact points!')
                                        ->persistent()
                                        ->send();

                                    continue; // skip this subcard
                                }

                                $subcard->buttons()->create([
                                    'user_id'   => $subcard->user_id, // ensure parent user is linked
                                    'type'      => $contact['type'],
                                    'title'     => $contact['title'],
                                    'link'      => $contact['link'] ?? null,
                                    'is_active' => $contact['is_active'] ?? true,
                                    'view'      => 'contacts',
                                ]);

                                Notification::make()
                                    ->title('Contacts Added')
                                    ->body('The new contact(s) have been added to all selected subcards.')
                                    ->success()
                                    ->send();
                            } catch (\InvalidArgumentException $e) {
                                Notification::make()
                                    ->title('Validation Error')
                                    ->body($e->getMessage())
                                    ->danger()
                                    ->send();
                            } catch (\Throwable $e) {
                                Notification::make()
                                    ->title('Error Adding Contact')
                                    ->body($e->getMessage())
                                    ->danger()
                                    ->send();
                            }
                        }
                    }
                }),


            Tables\Actions\BulkAction::make('addPayments')
                ->label('Add Payment(s)')
                ->icon('heroicon-o-banknotes')
                ->form([
                    Forms\Components\Repeater::make('payments')
                        ->label('Payments')
                        ->schema([
                            Forms\Components\Select::make('type')
                                ->required()
                                ->label('Payment Type')
                                ->reactive()
                                ->afterStateUpdated(function ($state, callable $set) {
                                    $urls = [
                                        'cashapp' => 'https://cash.app/$',
                                        'venmo' => 'https://venmo.com/u/',
                                        'paypal_link' => 'https://www.paypal.me/',
                                        'instagram' => 'https://www.instagram.com/',
                                    ];

                                    $titles = [
                                        'cashapp' => 'Cashapp',
                                        'paypal_link' => 'Paypal Link',
                                        'paypal_email' => 'Paypal Email',
                                        'apple_pay' => 'Apple Pay',
                                        'venmo' => 'Venmo',
                                        'credit' => 'Credit Card',
                                        'zelle' => 'Zelle',
                                    ];

                                    $set('link', $urls[$state] ?? '');
                                    $set('title', $titles[$state] ?? '');
                                })
                                ->options([
                                    'cashapp' => 'Cashapp',
                                    'paypal_link' => 'Paypal Link',
                                    'paypal_email' => 'Paypal Email',
                                    'apple_pay' => 'Apple Pay',
                                    'venmo' => 'Venmo',
                                    'credit' => 'Credit Card',
                                    'zelle' => 'Zelle',
                                ]),

                            Forms\Components\TextInput::make('title')
                                ->required()
                                ->maxLength(255),

                            Forms\Components\TextInput::make('link')
                                ->columnSpanFull()
                                ->required()
                                ->maxLength(255),

                            Forms\Components\Toggle::make('is_active')
                                ->label('Active')
                                ->default(true)
                                ->columnSpanFull(),
                        ])
                        ->minItems(1)
                        ->maxItems(10)
                        ->createItemButtonLabel('Add Another Payment'),
                ])
                ->modalButton('Add Payment(s)')
                ->action(function (\Illuminate\Support\Collection $records, array $data): void {
                    foreach ($records as $subcard) {
                        foreach ($data['payments'] as $payment) {
                            try {
                                // Format the link
                                Button::handleLinkFormatting($payment);

                                // Free plan restriction (if your subcards have user_type)
                                if (isset($subcard->user_type) && $subcard->user_type === 'Free' && $subcard->buttons()->where('view', 'payments')->count() >= 4) {
                                    Notification::make()
                                        ->warning()
                                        ->title('Free card holders can only add up to 4 payment links!')
                                        ->persistent()
                                        ->send();
                                    continue;
                                }

                                $subcard->buttons()->create([
                                    'type'      => $payment['type'],
                                    'title'     => $payment['title'],
                                    'link'      => $payment['link'],
                                    'is_active' => $payment['is_active'] ?? true,
                                    'view'      => 'payments',
                                    'user_id'   => $subcard->user_id, // preserve owner user_id
                                ]);

                                Notification::make()
                                    ->title('Payments Added')
                                    ->body('The new payment option(s) have been added to selected SubCards.')
                                    ->success()
                                    ->send();
                            } catch (\InvalidArgumentException $e) {
                                // Catch validation or formatting errors
                                Notification::make()
                                    ->title('Validation Error')
                                    ->body($e->getMessage())
                                    ->danger()
                                    ->send();

                                continue; // Skip this payment and move to the next
                            }
                        }
                    }
                }),


            Tables\Actions\BulkAction::make('addSocials')
                ->label('Add Social Links')
                ->icon('heroicon-o-globe-alt')
                ->form([
                    Forms\Components\Repeater::make('socials')
                        ->label('Social Links')
                        ->schema([
                            Forms\Components\Select::make('type')
                                ->required()
                                ->label('Social Media')
                                ->options([
                                    'facebook' => 'Facebook',
                                    'x' => 'X',
                                    'linkedin' => 'Linkedin',
                                    'instagram' => 'Instagram',
                                    'tiktok' => 'Tiktok',
                                    'youtube' => 'Youtube',
                                    'clubhouse' => 'Clubhouse',
                                    'threads' => 'Threads',
                                    'fanbase' => 'Fanbase',
                                    'snapchat' => 'Snapchat',
                                    'pinterest' => 'Pinterest',
                                    'soundcloud' => 'Sound Cloud',
                                    'apple_podcasts' => 'Apple Podcasts',
                                    'spotify' => 'Spotify',
                                    'discord' => 'Discord',
                                ])
                                ->reactive()
                                ->afterStateUpdated(function ($state, callable $get, callable $set) {
                                    $urls = [
                                        'facebook' => 'https://www.facebook.com/',
                                        'x' => 'https://x.com/',
                                        'linkedin' => 'https://www.linkedin.com/in/',
                                        'instagram' => 'https://www.instagram.com/',
                                        'tiktok' => 'https://www.tiktok.com/@',
                                        'youtube' => 'https://www.youtube.com/@',
                                        'clubhouse' => 'https://www.clubhouse.com/',
                                        'threads' => 'https://www.threads.net/@',
                                        'fanbase' => 'https://www.fanbase.app/@',
                                        'snapchat' => 'https://www.snapchat.com/add/',
                                        'pinterest' => 'https://www.pinterest.com/username',
                                        'soundcloud' => 'https://soundcloud.com/username',
                                        'apple_podcasts' => 'https://podcasts.apple.com/podcast/id',
                                        'spotify' => 'https://open.spotify.com/user/username',
                                        'discord' => 'https://discord.gg/invitecode',
                                    ];
                                    $set('link', $urls[$state] ?? '');
                                }),
                            Forms\Components\TextInput::make('link')
                                ->required()
                                ->maxLength(255),
                            Forms\Components\Toggle::make('is_active')
                                ->label('Active')
                                ->default(true),
                        ])
                        ->minItems(1),
                ])
                ->modalButton('Add Social Links')
                ->action(function (\Illuminate\Support\Collection $records, array $data) {
                    $freeLimit = 3;

                    foreach ($records as $subcard) {
                        foreach ($data['socials'] as $socialData) {
                            try {
                                Social::handleLinkFormatting($socialData);

                                // Check Free plan restriction
                                if (isset($subcard->user_type) && $subcard->user_type === 'Free' && $subcard->socials()->count() >= $freeLimit) {
                                    Notification::make()
                                        ->warning()
                                        ->title("Free card holders can only add up to {$freeLimit} social links!")
                                        ->persistent()
                                        ->send();
                                    continue; // skip adding more for this subcard
                                }

                                $subcard->socials()->create([
                                    'type'      => $socialData['type'],
                                    'link'      => $socialData['link'],
                                    'is_active' => $socialData['is_active'] ?? true,
                                    'user_id'   => $subcard->user_id,
                                ]);
                            } catch (\InvalidArgumentException $e) {
                                Notification::make()
                                    ->danger()
                                    ->title('Validation Error')
                                    ->body($e->getMessage())
                                    ->send();
                                continue;
                            }
                        }
                    }

                    Notification::make()
                        ->success()
                        ->title('Success')
                        ->body('Social links added successfully.')
                        ->send();
                }),
        ];
    }

    public static function bulkEditModalForm($fields, Collection $records)
    {
        if (is_null($fields)) {
            return Forms\Components\Placeholder::make('error')
                ->content('No fields selected');
        }

        $formFields = self::getBulkEditFormFields($fields);
        return Forms\Components\Section::make('Edit Fields')
            ->schema($formFields);
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([

                Tabs::make('Tabs')
                    ->tabs([
                        Tabs\Tab::make('Account')
                            ->schema([
                                Forms\Components\Section::make('Account Details')
                                    ->description('Manage account details here')
                                    ->schema([
                                        Select::make('user_id')
                                            ->label('Owner')
                                            ->placeholder('Search Client')
                                            ->getSearchResultsUsing(
                                                fn(string $search): array =>
                                                User::where(function ($query) use ($search) {

                                                    if (strpos($search, '@') === 0 && strlen($search) > 1) {
                                                        $query->where('username', 'like', "%" . substr($search, 1) . "%");
                                                    } else {
                                                        $query->where('firstname', 'like', "%{$search}%")
                                                            ->orWhere('lastname', 'like', "%{$search}%")
                                                            ->orWhere('username', 'like', "%{$search}%");
                                                    }
                                                })
                                                    ->where(function ($query) {
                                                        $query->where('user_type', 'Platinum')
                                                            ->orWhere('user_type', 'Gold');
                                                    })
                                                    ->limit(50)
                                                    // ->pluck(DB::raw('CONCAT(firstname, " ", lastname," - @", username)'), 'id')
                                                    ->pluck(DB::raw('CONCAT(IFNULL(firstname, ""), " ", IFNULL(lastname, ""), " - @", IFNULL(username, ""))'), 'id')

                                                    ->toArray()
                                            )
                                            // ->getOptionLabelUsing(
                                            //     fn($value) =>
                                            //     optional(User::find($value))->firstname . ' ' . optional(User::find($value))->lastname
                                            // )
                                            ->getOptionLabelUsing(function ($value) {
                                                $user = User::find($value);
                                                return $user ? "{$user->firstname} {$user->lastname}" : '';
                                            })
                                            ->searchable()
                                            ->required()
                                            // ->helperText(new HtmlString('Only <strong>Gold</strong> & <strong>Platinum</strong> card holders can add sub card(s)'))
                                            ->helperText(function () {
                                                $settings = app(CardDefaultsSetting::class);

                                                return new HtmlString(
                                                    'Only <strong>' . e($settings->term_gold) . '</strong> & <strong>' . e($settings->term_platinum) . '</strong> card holders can add sub card(s).'
                                                );
                                            })
                                            ->afterStateUpdated(function (Set $set, $state) {
                                                // Check if the selected user has 5 or more videos
                                                $user = User::find($state);

                                                // \Filament\Notifications\Notification::make()
                                                //     ->title('User ID selected: ' . $state)
                                                //     ->send();

                                                if ($user->user_type == "Platinum" && $user->subcards()->count() >= 12) {
                                                    // Trigger a notification
                                                    Notification::make()
                                                        ->title('Limit reached')
                                                        ->body('Platinum card holders can only add up to 12 sub cards!')
                                                        ->warning()
                                                        ->send();
                                                    // Optionally, you can reset the state or show a validation error:
                                                    $set('user_id', null); // Reset the user_id if limit is reached
                                                }
                                                if ($user->user_type == "Gold" && $user->subcards()->count() >= 3) {
                                                    // Trigger a notification
                                                    Notification::make()
                                                        ->title('Limit reached')
                                                        ->body('Gold card holders can only add up to 3 sub cards!')
                                                        ->warning()
                                                        ->send();
                                                    // Optionally, you can reset the state or show a validation error:
                                                    $set('user_id', null); // Reset the user_id if limit is reached
                                                }
                                            }),

                                        Forms\Components\TextInput::make('username')
                                            ->reactive()
                                            ->live(onBlur: true)
                                            ->afterStateUpdated(function (callable $set, $state) {
                                                $set('footer_link', app(CardDefaultsSetting::class)->site_url . 'register?ref=' . $state);
                                            })
                                            ->required()
                                            ->label('Username')
                                            ->maxLength(50)
                                            ->rule('regex:/^[a-zA-Z0-9_.]+$/')
                                            ->rule(function ($get, $livewire) {
                                                return function (string $attribute, $value, $fail) use ($livewire) {
                                                    $record = $livewire->record ?? null;

                                                    // Only validate if creating or the username has changed
                                                    if (!$record || $record->username !== $value) {
                                                        $userExists = DB::table('users')->where('username', $value)->exists();
                                                        $subcardExists = DB::table('subcards')->where('username', $value)->exists();

                                                        if ($userExists || $subcardExists) {
                                                            $fail("The username '$value' is already taken.");
                                                        }
                                                    }
                                                };
                                            })
                                            ->helperText('Only letters, numbers, and underscores allowed.'),

                                        Forms\Components\Toggle::make('is_active')
                                            ->label('Card Active')
                                            ->default(true)
                                            ->columnSpanFull()
                                            ->required(),
                                    ]),

                                Forms\Components\Section::make('Personal Details')
                                    ->description('Manage personal details here')
                                    ->schema([

                                        FileUpload::make('profile_pic')
                                            ->label('Upload Profile Picture')
                                            ->placeholder('Upload Profile Picture')
                                            ->directory('profile_pic')
                                            ->uploadingMessage('Uploading Profile Picture. Please wait...')
                                            ->image()
                                            ->imageEditor()
                                            ->columnSpanFull()
                                            ->imageResizeMode('cover')
                                            ->imageCropAspectRatio('1:1')
                                            ->imageResizeTargetWidth('520')
                                            ->imageResizeTargetHeight('520')
                                            ->getUploadedFileNameForStorageUsing(
                                                fn(TemporaryUploadedFile $file): string =>
                                                (string) Str::random(40) . '.' . $file->getClientOriginalExtension()
                                            )
                                            ->imageEditorAspectRatios([
                                                '1:1',
                                            ]),

                                        // Thumbnail
                                        FileUpload::make('thumbnail')
                                            ->label('Upload Custom Thumbnail')
                                            ->placeholder('Upload Custom Thumbnail')
                                            ->directory('thumbnails')
                                            ->uploadingMessage('Uploading Custom Thumbnail. Please wait...')
                                            ->image()
                                            ->imageEditor()
                                            ->columnSpanFull()
                                            ->imageResizeMode('cover')
                                            ->imageCropAspectRatio('1:1')
                                            ->imageResizeTargetWidth('520')
                                            ->imageResizeTargetHeight('520')
                                            ->getUploadedFileNameForStorageUsing(
                                                fn(TemporaryUploadedFile $file): string =>
                                                (string) Str::random(40) . '.' . $file->getClientOriginalExtension()
                                            )
                                            ->imageEditorAspectRatios([
                                                '1:1',
                                            ])
                                            ->reactive(),

                                        FileUpload::make('cover_pic')
                                            ->reactive()
                                            ->afterStateUpdated(function (callable $set, callable $get, $state) {
                                                // Only set profile_layout if it's not already manually changed
                                                if (!empty($state)) {
                                                    $set('profile_layout', 'default_cover');
                                                }
                                            })
                                            ->label('Upload Cover Picture')
                                            ->placeholder('Upload Cover Picture')
                                            ->directory('cover_pic')
                                            ->uploadingMessage('Uploading Cover Picture. Please wait...')
                                            ->image()
                                            ->imageEditor()
                                            ->columnSpanFull()
                                            ->imageResizeMode('cover')
                                            ->imageCropAspectRatio('1080:600')
                                            ->imageResizeTargetWidth('1080')
                                            ->imageResizeTargetHeight('600')
                                            ->getUploadedFileNameForStorageUsing(
                                                fn(TemporaryUploadedFile $file): string =>
                                                (string) Str::random(40) . '.' . $file->getClientOriginalExtension()
                                            )
                                            ->imageEditorAspectRatios([
                                                '1080:600',
                                            ]),

                                        Forms\Components\TextInput::make('firstname')
                                            ->required()
                                            ->maxLength(255)
                                            ->default(null),
                                        Forms\Components\TextInput::make('lastname')
                                            ->required()
                                            ->maxLength(255)
                                            ->default(null),
                                    ])->columns(2),

                                Forms\Components\Section::make('Contact Details')
                                    ->description('Manage contact details here')
                                    ->schema([
                                        Forms\Components\TextInput::make('email')
                                            // ->required()
                                            ->email(),

                                        Forms\Components\TextInput::make('phone')
                                            // ->required()
                                            ->maxLength(20),

                                    ])->columns(2),

                                Forms\Components\Section::make('Occupation Details')
                                    ->description('Manage occupation details here')
                                    ->schema([
                                        Forms\Components\TextInput::make('job_title')
                                            ->required()
                                            ->maxLength(200)
                                            ->default(null),

                                        Forms\Components\TextInput::make('company')

                                            ->maxLength(255)
                                            ->default(null),

                                        Forms\Components\TextInput::make('company_website')
                                            ->maxLength(255)
                                            ->url()
                                            ->columnSpanFull()
                                            ->default(null),

                                        Forms\Components\Textarea::make('bio')
                                            ->maxLength(200)
                                            ->columnSpanFull()
                                            ->helperText('Write a few sentences about yourself. Max character 200.'),

                                        // TinyEditor::make('bio_long')
                                        //     ->label('Long Bio')
                                        //     ->profile('custom')
                                        //     ->columnSpan('full')
                                        //     ->maxLength(1000)
                                        //     ->helperText('Write your bio. Max character 1000.')
                                        //     ->rule(function ($get) {
                                        //         return function (string $attribute, $value, $fail) {
                                        //             if (Str::length(strip_tags($value)) > 1000) {
                                        //                 $fail('The long bio must not exceed 1000 characters.');
                                        //             }
                                        //         };
                                        //     }),

                                        // RichEditor::make('bio_long')
                                        //     ->label('Long Bio')
                                        //     ->columnSpan('full')
                                        //     ->reactive()
                                        //     ->live()
                                        //     ->toolbarButtons([
                                        //         'bold',
                                        //         'italic',
                                        //         'underline',
                                        //         'strike',
                                        //         'bulletList',
                                        //         'numberList',
                                        //         'link',
                                        //         'h2',   // Heading 2
                                        //         'h3',   // Heading 3
                                        //     ])
                                        //     ->disableToolbarButtons([
                                        //         'codeBlock',
                                        //         'blockquote',
                                        //         'table',
                                        //         'media'
                                        //     ])
                                        //     // ->afterStateUpdated(function ($state, $set) {
                                        //     //     $plainText = strip_tags($state ?? '');
                                        //     //     if (Str::length($plainText) > 1000) {
                                        //     //         // trim the plain text to 1000 characters
                                        //     //         $trimmedText = Str::substr($plainText, 0, 1000);

                                        //     //         // optional: try to keep simple HTML formatting by wrapping back into paragraph
                                        //     //         $set('bio_long', "<p>{$trimmedText}</p>");
                                        //     //     }
                                        //     // })
                                        //     ->rule(fn($get) => function ($attribute, $value, $fail) {
                                        //         $plainText = strip_tags($value ?? '');
                                        //         if (Str::length($plainText) > 5000) {
                                        //             $fail('The long bio must not exceed 5000 characters.');
                                        //         }
                                        //     })
                                        //     ->extraAttributes([
                                        //         'class' => 'max-h-[300px] overflow-y-auto'
                                        //     ]),

                                        // TinyEditor::make('bio_long')
                                        //     ->label('Long Bio')
                                        //     ->profile('custom') // define this profile in config
                                        //     ->reactive()
                                        //     ->live()
                                        //     ->columnSpan('full')
                                        //     ->helperText('Write your bio. Max character 5000.')
                                        //     ->afterStateUpdated(function ($state, $set) {
                                        //         $plainText = strip_tags($state ?? '');
                                        //         $set('bio_long_count', Str::length($plainText)); // keep server-side fallback
                                        //     })
                                        //     ->rule(fn($get) => function ($attribute, $value, $fail) {
                                        //         $plainText = strip_tags($value ?? '');
                                        //         if (Str::length($plainText) > 5000) {
                                        //             $fail('The long bio must not exceed 5000 characters.');
                                        //         }
                                        //     }),

                                        // FilamentLexicalEditor::make('bio_long')
                                        //     ->columnSpanFull()
                                        //     ->reactive()
                                        //     // ->live()
                                        //     ->label('Long Bio')
                                        //     // ->hidden(fn(callable $get) => !in_array($get('user_type') ?? null, ['Sponsored', 'Gold', 'Platinum']))
                                        //     ->enabledToolbars([
                                        //         ToolbarItem::BOLD,
                                        //         ToolbarItem::ITALIC,
                                        //         ToolbarItem::UNDERLINE,
                                        //         ToolbarItem::LINK,
                                        //         // ToolbarItem::PARAGRAPH,
                                        //         ToolbarItem::LEFT,
                                        //         ToolbarItem::CENTER,
                                        //         ToolbarItem::RIGHT,
                                        //         ToolbarItem::JUSTIFY,
                                        //         ToolbarItem::BULLET,
                                        //         ToolbarItem::NUMBERED,
                                        //     ])
                                        //     ->helperText('Write your bio. Max character 5000.')
                                        //     ->afterStateUpdated(function ($state, $set) {
                                        //         $plainText = strip_tags($state ?? '');
                                        //         $set('bio_long_count', Str::length($plainText));
                                        //     }),


                                        CKEditor::make('bio_long')
                                            ->label('Long Bio')
                                            ->columnSpanFull()

                                            // Only visible for these user types
                                            // ->hidden(fn($get) => ! in_array($get('user_type'), ['Sponsored', 'Gold', 'Platinum']))

                                            ->placeholder('Write your bio here...')
                                            ->helperText('Max 5000 characters.')
                                            // Character counter initial load
                                            ->afterStateHydrated(function ($state, $set) {
                                                $plain = strip_tags($state ?? '');
                                                $set('bio_long_count', Str::length($plain));
                                            })

                                            // Update counter on typing
                                            ->afterStateUpdated(function ($state, $set) {
                                                $plain = strip_tags($state ?? '');
                                                $set('bio_long_count', Str::length($plain));
                                            })

                                            // Validation rule
                                            ->rule(function () {
                                                return function ($attribute, $value, $fail) {
                                                    $plain = strip_tags($value ?? '');
                                                    if (Str::length($plain) > 5000) {
                                                        $fail('The long bio must not exceed 5000 characters.');
                                                    }
                                                };
                                            }),


                                        // Live character counter
                                        ViewField::make('bio_long_count')
                                            ->view('forms.bio-long-counter')
                                            ->columnSpan('full'),
                                    ])->columns(2),

                            ]),
                        Tabs\Tab::make('Content')
                            ->schema([
                                // Related UserSettings fields
                                Forms\Components\Section::make('Card Contents')
                                    ->schema([
                                        Forms\Components\Select::make('profile_layout')
                                            ->label('Profile Picture Layout')
                                            ->default('default')
                                            ->columnSpanFull()
                                            ->reactive()
                                            ->options([
                                                'default' => 'Default',
                                                'rounded' => 'Rounded',
                                                'default_cover' => 'With Cover',
                                                'full_width' => 'Full Width',
                                                'cover_only' => 'Cover Only',
                                            ]),
                                        Forms\Components\TextInput::make('card_custom_title')
                                            ->label('Display Name')
                                            ->columnSpanFull()
                                            ->placeholder('Default will be the fullname'),

                                        Forms\Components\TextInput::make('custom_page_title')
                                            ->columnSpanFull()
                                            ->placeholder('Default will be the custom display name or fullname')
                                            ->label('Page Title'),
                                    ])->columns(2),

                                Forms\Components\Section::make('Gallery')
                                    ->schema([
                                        Forms\Components\Toggle::make('gallery_two_slide')
                                            ->label('Gallery 2 images per slide')
                                            ->default(true),
                                    ]),

                                Forms\Components\Section::make('Custom Text')
                                    ->schema([
                                        Forms\Components\TextInput::make('contact_text')
                                            ->default('Contact me')
                                            ->label('Contact Text'),

                                        Forms\Components\TextInput::make('follow_text')
                                            ->default('Follow me')
                                            ->label('Follow Text'),

                                        // Forms\Components\TextInput::make('bio_text')
                                        //     ->default('My Bio')
                                        //     ->label('Bio Text'),

                                        Forms\Components\TextInput::make('event_text')
                                            ->default('Events')
                                            ->label('Events Text'),

                                        Forms\Components\TextInput::make('payment_text')
                                            ->default('Payments')
                                            ->label('Payment Links'),

                                    ])->columns(2),

                                Forms\Components\Section::make('Footer Content')
                                    ->schema([
                                        Forms\Components\TextInput::make('footer_text')
                                            // ->required()
                                            ->label('Footer Link Text')
                                            ->default(app(CardDefaultsSetting::class)->footer_text),

                                        Forms\Components\TextInput::make('footer_link')
                                            // ->required()
                                            ->label('Footer Link'),

                                    ])->columns(2),

                                Forms\Components\Section::make('Shop')
                                    // ->visible(fn(callable $get) => !in_array($get('user_type'), ['Sponsored', 'Free', 'Basic']))
                                    ->schema([
                                        Forms\Components\TextInput::make('shop_text')
                                            ->label('Shop Title'),

                                        Forms\Components\TextInput::make('shop_more')
                                            ->label('Shop More URL')
                                            ->url(),

                                        FileUpload::make('shop_thumbnail')
                                            ->label('Shop Thumbnail')
                                            ->placeholder('Upload Shop Thumbnail')
                                            ->directory('thumbnails')
                                            ->uploadingMessage('Uploading Custom Thumbnail. Please wait...')
                                            ->image()
                                            ->imageEditor()
                                            ->multiple(false) // ✅ only one image
                                            ->columnSpanFull()
                                            ->imageResizeMode('cover')
                                            ->imageCropAspectRatio('1:1')
                                            ->imageResizeTargetWidth('520')
                                            ->imageResizeTargetHeight('520')
                                            ->getUploadedFileNameForStorageUsing(
                                                fn(TemporaryUploadedFile $file): string =>
                                                (string) Str::random(40) . '.' . $file->getClientOriginalExtension()
                                            )
                                            ->imageEditorAspectRatios([
                                                '1:1',
                                            ])

                                    ]),

                                Forms\Components\Section::make('Services')
                                    // ->visible(fn(callable $get) => !in_array($get('user_type'), ['Sponsored', 'Free', 'Basic']))
                                    ->schema([
                                        Forms\Components\TextInput::make('services_text')
                                            ->label('Services Button Title'),
                                    ]),
                            ]),

                        Tabs\Tab::make('Theme')
                            ->schema([
                                Forms\Components\Select::make('preset')
                                    ->helperText('Select color preset or customize')
                                    ->label('Select Preset')
                                    ->options(function () {
                                        return ColorPreset::pluck('title', 'id')->toArray() + ['Custom' => 'Custom'];
                                    })
                                    ->reactive()
                                    ->afterStateUpdated(function ($state, callable $set) {
                                        if ($state === 'Custom') {
                                            return; // do not auto-fill
                                        }

                                        $preset = \App\Models\ColorPreset::find($state);
                                        if (! $preset) return;

                                        $set('color_settings_custom_button', $preset->custom_button);
                                        $set('color_settings_custom_button_text', $preset->custom_button_text);
                                        $set('color_settings_link', $preset->link);
                                        $set('color_settings_profile_pic_border', $preset->profile_pic_border);
                                        $set('color_settings_card_light', $preset->card_light);
                                        $set('color_settings_card_dark', $preset->card_dark);
                                        $set('color_settings_text_light', $preset->text_light);
                                        $set('color_settings_text_dark', $preset->text_dark);
                                    }),

                                Forms\Components\Section::make('Custom')
                                    ->visible(fn(callable $get) => $get('preset') == 'Custom')
                                    ->schema([
                                        ColorPicker::make('color_settings_custom_button')
                                            ->label('Button Color')
                                            ->lazy()
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#facc15'),

                                        ColorPicker::make('color_settings_custom_button_text')
                                            ->label('Button Text Color')
                                            ->lazy()
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#000000'),

                                        ColorPicker::make('color_settings_link')
                                            ->label('Link Color')
                                            ->lazy()
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#ca8a04'),

                                        ColorPicker::make('color_settings_profile_pic_border')
                                            ->label('Profile Pic Border Color')
                                            ->lazy()
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#ca8a04'),

                                        ColorPicker::make('color_settings_card_light')
                                            ->label('Light Mode Background Color')
                                            ->lazy()
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#ffffff'),

                                        ColorPicker::make('color_settings_card_dark')
                                            ->label('Dark Mode Background Color')
                                            ->lazy()
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#18181b'),

                                        ColorPicker::make('color_settings_text_light')
                                            ->label('Light Mode Font Color')
                                            ->lazy()
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#1e293b'),

                                        ColorPicker::make('color_settings_text_dark')
                                            ->label('Dark Mode Font Color')
                                            ->lazy()
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#cbd5e1'),
                                    ])->columns(2),

                                Forms\Components\Select::make('button_style')
                                    ->label('Button Style')
                                    ->options([
                                        'rounded' => 'Rounded',
                                        'squared' => 'Squared',
                                    ]),
                            ]),
                        Tabs\Tab::make('Visibility')
                            ->schema([
                                Forms\Components\Toggle::make('searchable')
                                    ->label('Search Visibility')
                                    ->default(true),

                                Forms\Components\Toggle::make('display_username')
                                    ->label('Username Handle')
                                    ->default(true),

                                Forms\Components\Toggle::make('display_short_bio')
                                    ->label('Short Bio')
                                    ->default(true),

                                Forms\Components\Toggle::make('display_country')
                                    ->label('Country')
                                    ->default(true),

                                Forms\Components\Toggle::make('connect_main')
                                    ->visible(fn(callable $get) => $get('user_type') != 'Free')
                                    ->label("Let's Connect (Main Card)")
                                    ->default(true),

                                Forms\Components\Toggle::make('connect_bio')
                                    ->visible(fn(callable $get) => $get('user_type') != 'Free')
                                    ->label("Let's Connect (Bio Page)")
                                    ->default(false),

                                Forms\Components\Toggle::make('gallery_main')
                                    ->label("Gallery (Main Card)")
                                    ->default(true),

                                Forms\Components\Toggle::make('gallery_bio')
                                    ->label("Gallery (Bio Page)")
                                    ->default(false),

                                Forms\Components\Toggle::make('product_price_enabled')
                                    ->label("Product Price")
                                    ->default(true),

                                Forms\Components\Toggle::make('services_price_enabled')
                                    ->label("Services Price")
                                    ->default(true),

                                Forms\Components\Toggle::make('getacard_enabled')
                                    ->label('"Get a card like this" Button')
                                    ->default(false),

                                Forms\Components\Toggle::make('footer_enabled')
                                    ->visible(fn(callable $get) => $get('user_type') != 'Free')
                                    ->label("Footer")
                                    ->default(true),
                            ]),
                    ])
                    ->activeTab(1)
                    ->columnSpanFull()
            ]);
    }

    public static function getScripts(): array
    {
        return [
            <<<JS
        document.addEventListener('livewire:load', () => {

            const initVisibleEditors = () => {
                document.querySelectorAll('.lexical-editor').forEach(editor => {
                    const isVisible = editor.offsetParent !== null;

                    if (!isVisible) return;

                    // Avoid double init
                    if (editor.__lexicalInitialized) return;

                    // Wait for Filament to fully render inner HTML
                    setTimeout(() => {
                        if (window.initLexicalEditor) {
                            window.initLexicalEditor(editor);
                            editor.__lexicalInitialized = true;
                        }
                    }, 300);
                });
            };

            Livewire.hook('message.processed', () => {
                setTimeout(initVisibleEditors, 300);
            });

            const observer = new MutationObserver(() => {
                setTimeout(initVisibleEditors, 300);
            });

            observer.observe(document.body, { attributes: true, childList: true, subtree: true });

            setTimeout(initVisibleEditors, 500);
        });
        JS,
        ];
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([

                // Tables\Columns\IconColumn::make('is_active')
                //     ->label('Active')
                //     ->boolean()
                //     ->searchable(),

                Tables\Columns\ToggleColumn::make('is_active')
                    ->label('Active')
                    ->onColor('success') // ✅ green when active
                    ->offColor('danger'), // ❌ red when inactive

                Tables\Columns\TextColumn::make('user.firstname')
                    ->label('Owner')
                    ->getStateUsing(function ($record) {
                        return $record->user ? $record->user->firstname . ' ' . $record->user->lastname : 'N/A';
                    })
                    ->searchable(['firstname', 'lastname']),
                Tables\Columns\TextColumn::make('username')
                    ->badge()
                    ->searchable()
                    ->label('Card Link')
                    ->color('primary')
                    ->searchable(query: function ($query, $search) {
                        $query->orWhere('username', 'like', '%' . ltrim($search, '@') . '%');
                    })
                    ->url(function ($record) {
                        $siteUrl = app(CardDefaultsSetting::class)->site_url;
                        return "{$siteUrl}{$record->username}";
                    })
                    ->formatStateUsing(fn($state) => '@' . $state)
                    ->openUrlInNewTab(),

                Tables\Columns\TextColumn::make('email')
                    ->searchable()
                    ->label('Email'),

                Tables\Columns\TextColumn::make('firstname')
                    ->label('Name on Card')
                    ->getStateUsing(function ($record) {
                        return $record ? $record->firstname . ' ' . $record->lastname : 'N/A';
                    })
                    ->searchable(['firstname', 'lastname']),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Created')
                    ->sortable()
                    //  ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y | D | h:i a')),
                    ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),

            ])->defaultSort('created_at', 'desc')
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\Action::make('view_card')
                        ->label('View')
                        ->icon('heroicon-o-eye')
                        ->url(fn($record) => app(CardDefaultsSetting::class)->site_url . $record->username)
                        ->openUrlInNewTab()
                        ->color('info'), // Optional: info, success, warning, danger, gray, etc.
                    Tables\Actions\EditAction::make(),

                    Tables\Actions\Action::make('customAction')
                        ->icon('heroicon-o-document-duplicate')
                        ->label('Duplicate')
                        ->color('warning')
                        ->action(function (Model $record) {
                            DB::transaction(function () use ($record) {

                                // Helper to duplicate a file into a specific folder
                                // $duplicateFile = function (?string $filePath) {
                                //     if (!$filePath || !Storage::disk('public')->exists($filePath)) {
                                //         return null;
                                //     }

                                //     $directory = dirname($filePath); // e.g. profile_pic
                                //     $extension = pathinfo($filePath, PATHINFO_EXTENSION);
                                //     $originalName = pathinfo($filePath, PATHINFO_FILENAME);
                                //     $newFileName = $originalName . '_' . Str::random(6) . '.' . $extension;
                                //     $newPath = $directory . '/' . $newFileName;

                                //     Storage::disk('public')->makeDirectory($directory);
                                //     Storage::disk('public')->copy($filePath, $newPath);

                                //     return $newPath;
                                // };

                                $duplicateFile = function (?string $filePath) {
                                    if (!$filePath || !Storage::disk('public')->exists($filePath)) {
                                        return null;
                                    }

                                    $directory = dirname($filePath); // e.g. profile_pic
                                    $extension = pathinfo($filePath, PATHINFO_EXTENSION);
                                    $originalName = pathinfo($filePath, PATHINFO_FILENAME);

                                    // Limit the original name length to avoid filesystem errors
                                    $maxBaseLength = 50; // adjust as needed (e.g. 50 chars)
                                    $shortName = Str::limit($originalName, $maxBaseLength, '');

                                    $newFileName = $shortName . '_' . Str::random(6) . '.' . $extension;
                                    $newPath = $directory . '/' . $newFileName;

                                    Storage::disk('public')->makeDirectory($directory);
                                    Storage::disk('public')->copy($filePath, $newPath);

                                    return $newPath;
                                };

                                // Duplicate logic here
                                $newRecord = $record->replicate(); // Clone the record

                                // Modify unique fields to avoid conflicts
                                $newRecord->username = $record->username . '_' . uniqid(); // Add random suffix
                                $newRecord->email = uniqid() . '_' . $record->email; // Or generate a dummy email if needed

                                // Duplicate each image to its respective folder
                                $newRecord->thumbnail = $duplicateFile($record->thumbnail);
                                $newRecord->profile_pic = $duplicateFile($record->profile_pic);
                                $newRecord->cover_pic = $duplicateFile($record->cover_pic);

                                //dont replicate the following
                                $newRecord->phone = NULL;
                                $newRecord->email = NULL;
                                $newRecord->created_at = Carbon::now();
                                $newRecord->updated_at = Carbon::now();
                                $newRecord->firstname = NULL;
                                $newRecord->lastname = NULL;
                                $newRecord->job_title = NULL;
                                $newRecord->bio = NULL;
                                $newRecord->bio_long = NULL;
                                $newRecord->company = NULL;
                                $newRecord->company_website = NULL;

                                $newRecord->is_duplicated = true;

                                $newRecord->save();

                                //replicate settings
                                if ($record->settings) {
                                    foreach ($record->settings as $settings) {
                                        $newSettings = $settings->replicate();
                                        $newSettings->page_id = $newRecord->id;
                                        $newSettings->save();
                                    }
                                }

                                if ($record->buttons()->exists()) {
                                    foreach ($record->buttons()->orderBy('order')->get() as $button) {
                                        // Replicate the button
                                        $newButton = $button->replicate();
                                        $newButton->page_id = $newRecord->id;
                                        $newButton->order = $button->order;
                                        $newButton->save();

                                        // If it's a "team" type button, replicate its members
                                        if ($newButton->type === 'team') {
                                            foreach ($button->members as $member) {
                                                $newMember = $member->replicate();
                                                $newMember->team_id = $newButton->id;
                                                $newMember->member_id = $member->member_id;
                                                $newMember->card_type = $member->card_type;
                                                $newMember->order = $member->order;
                                                $newMember->custom_card_link = $member->custom_card_link;
                                                $newMember->save();
                                            }
                                        }
                                    }
                                }

                                //replicate socials
                                if ($record->socials) {
                                    // foreach ($record->socials as $socials) {
                                    foreach ($record->socials()->orderBy('order')->get() as $socials) {
                                        $newSocials = $socials->replicate();
                                        $newSocials->page_id = $newRecord->id;
                                        $newSocials->order = $socials->order;
                                        $newSocials->save();
                                    }
                                }

                                //replicate videos
                                if ($record->videos) {
                                    // foreach ($record->videos as $videos) {
                                    foreach ($record->videos()->orderBy('order')->get() as $videos) {
                                        $newVideos = $videos->replicate();
                                        $newVideos->page_id = $newRecord->id;
                                        $newVideos->order = $videos->order;
                                        $newVideos->save();
                                    }
                                }

                                //replicate ads
                                if ($record->ads) {
                                    // foreach ($record->ads as $ads) {
                                    foreach ($record->ads()->orderBy('order')->get() as $ads) {
                                        $newAds = $ads->replicate();
                                        $newAds->image = $duplicateFile($ads->image);
                                        $newAds->page_id = $newRecord->id;
                                        $newAds->order = $ads->order;
                                        $newAds->save();
                                    }
                                }

                                //replicate driving directions
                                if ($record->directions) {
                                    foreach ($record->directions()->orderBy('order')->get() as $directions) {
                                        $newDirections = $directions->replicate();
                                        $newDirections->page_id = $newRecord->id;
                                        $newDirections->order = $directions->order;
                                        $newDirections->save();
                                    }
                                }

                                // replicate products and their media
                                if ($record->products) {
                                    foreach ($record->products()->orderBy('order')->get() as $product) {
                                        $newProduct = $product->replicate();
                                        $newProduct->featured_image = $duplicateFile($product->featured_image);
                                        $newProduct->page_id = $newRecord->id;
                                        $newProduct->order = $product->order;
                                        $newProduct->save();

                                        // replicate associated product media
                                        if ($product->media && $product->media()->exists()) {
                                            foreach ($product->media()->orderBy('order')->get() as $media) {
                                                $newMedia = $media->replicate();
                                                // ✅ Only duplicate the file if it's an image
                                                if ($media->type === 'image') {
                                                    $newPath = $duplicateFile($media->path);

                                                    // skip if file missing or invalid
                                                    if (!$newPath) {
                                                        continue;
                                                    }

                                                    $newMedia->path = $newPath;
                                                } else {
                                                    // non-image types (video, pdf, etc.) keep the same path
                                                    $newMedia->path = $media->path;
                                                }

                                                $newMedia->product_id = $newProduct->id; // link to new product
                                                $newMedia->order = $media->order;
                                                $newMedia->save();
                                            }
                                        }
                                    }
                                }

                                //replicate services
                                if ($record->services) {
                                    // foreach ($record->services as $services) {
                                    foreach ($record->services()->orderBy('order')->get() as $services) {
                                        $newServices = $services->replicate();
                                        $newServices->service_image = $duplicateFile($services->service_image);
                                        $newServices->page_id = $newRecord->id;
                                        $newServices->order = $services->order;
                                        $newServices->save();
                                    }
                                }

                                //replicate images
                                if ($record->images) {
                                    // foreach ($record->images as $images) {
                                    foreach ($record->images()->orderBy('order')->get() as $images) {
                                        $newImages = $images->replicate();
                                        $newImages->image_path = $duplicateFile($images->image_path);
                                        $newImages->page_id = $newRecord->id;
                                        $newImages->order = $images->order;
                                        $newImages->save();
                                    }
                                }

                                //replicate events
                                if ($record->events) {
                                    // foreach ($record->services as $services) {
                                    foreach ($record->events()->orderBy('order')->get() as $events) {
                                        $newEvents = $events->replicate();
                                        $newEvents->event_poster = $duplicateFile($events->event_poster);
                                        $newEvents->page_id = $newRecord->id;
                                        $newEvents->order = $events->order; // ✅ preserve original order
                                        $newEvents->save();
                                    }
                                }

                                // Optional: You could redirect or notify
                                Notification::make()
                                    ->title('Success')
                                    ->body('Sub Card duplicated successfully.')
                                    ->success()
                                    ->send();
                            });
                        }),

                ])
                    // ->dropdown(false)
                    ->label('Actions') // optional — can be hidden if you prefer
                    ->icon('heroicon-o-cog-6-tooth') // optional
                    ->color('gray'), // ✅ ensures buttons are left-aligned


            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
                Tables\Actions\BulkActionGroup::make(static::getTableBulkActions()),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            PagesRelationManager::class,
            ButtonsRelationManager::class,
            SocialsRelationManager::class,
            PaymentRelationManager::class,
            ContactsRelationManager::class,
            DirectionsRelationManager::class,
            CommunitiesRelationManager::class,
            ProductsRelationManager::class,
            CategoryRelationManager::class,
            ProductCollectionRelationManager::class,
            ServicesRelationManager::class,
            VideosRelationManager::class,
            AdRelationManager::class,
            ImagesRelationManager::class,
            EventsRelationManager::class,
            // SalesRelationManager::class,
            TeamsRelationManager::class,
            TrustedNetworkRelationManager::class,
            ReplaysRelationManager::class,
            ReviewsRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSubCards::route('/'),
            'create' => Pages\CreateSubCards::route('/create'),
            'edit' => Pages\EditSubCards::route('/{record}/edit'),
            'view' => Pages\ViewSubCards::route('/{record}'),
        ];
    }
}
