<?php

namespace App\Filament\Resources\ProductResource\Pages;

use App\Filament\Resources\ProductResource;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Str;

class CreateProduct extends CreateRecord
{
    protected static string $resource = ProductResource::class;

    public ?string $ownerKey = null;

    public function mount(): void
    {
        parent::mount();

        $this->ownerKey = request()->query('ownerKey');

        if ($this->ownerKey) {
            if (Str::startsWith($this->ownerKey, 'user-')) {
                $userId = substr($this->ownerKey, 5);
                $this->data['owner']   = "user-{$userId}";
                $this->data['user_id'] = $userId;
                $this->data['page_id'] = null;
            } elseif (Str::startsWith($this->ownerKey, 'sub-')) {
                $subId = substr($this->ownerKey, 4);
                $this->data['owner']   = "sub-{$subId}";
                $this->data['page_id'] = $subId;
                $this->data['user_id'] = null;
            }
        }
    }
}
