<?php

namespace App\Filament\Resources\LeadCaptureFormResource\Pages;

use App\Filament\Resources\LeadCaptureFormResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use App\Settings\CardDefaultsSetting;

class EditLeadCaptureForm extends EditRecord
{
    protected static string $resource = LeadCaptureFormResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('view_form')
                ->label('View')
                ->icon('heroicon-o-eye')
                ->url(function ($record) {
                    if (!$record) return '#';

                    $baseUrl = app(\App\Settings\CardDefaultsSetting::class)->site_url;

                    if ($record->page_id && $record->subcard) {
                        return $baseUrl . $record->subcard->username . '/form/' . $record->slug;
                    }

                    if ($record->user) {
                        return $baseUrl . $record->user->username . '/form/' . $record->slug;
                    }

                    return '#';
                })
                // ->url(fn($record) => app(CardDefaultsSetting::class)->site_url . $record->user->username . '/form/' . $record->slug)
                ->openUrlInNewTab()
                ->color('info'),

            Actions\DeleteAction::make(),
        ];
    }
}
