<?php

namespace App\Filament\Resources\AdResource\Widgets;

use Carbon\Carbon;
use App\Models\Analytics;
use App\Models\Ad;
use Filament\Widgets\ChartWidget;
use Flowframe\Trend\Trend;
use Flowframe\Trend\TrendValue;
use Illuminate\Database\Eloquent\Model;

class SpecificAdminAdAnalyticsOneWeek extends ChartWidget
{
    protected static ?string $heading = 'Ad clicks (Last 6 Months)';
    protected static string $color = 'success';
    public ?Model $record = null;

    protected function getData(): array
    {
        // $adIds = Ad::where('is_active', true)
        //     ->where('display_in', 'Free')
        //     ->pluck('id');

        $adIds = Ad::where('id', $this->record->id)
            ->pluck('id');

        $data = Trend::query(
            Analytics::where('type', 'ad_click')
                ->where('ad_id', $adIds)
        )
            ->dateColumn('clicked_at')
            ->between(
                start: now()->subDays(6),
                end: now(),
            )
            ->perDay()
            ->count();

        return [
            'datasets' => [
                [
                    'label' => 'Ad clicks per day',
                    'data' => $data->map(fn(TrendValue $value) => $value->aggregate),
                ],
            ],
            'labels' => $data->map(fn(TrendValue $value) => Carbon::parse($value->date)->format('D')), // e.g., Mon, Tue
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }
}
