<?php

namespace App\Filament\Resources\AdResource\Widgets;

use Carbon\Carbon;
use App\Models\Analytics;
use App\Models\Ad;
use Filament\Widgets\ChartWidget;
use Flowframe\Trend\Trend;
use Flowframe\Trend\TrendValue;
use Illuminate\Database\Eloquent\Model;

class SpecificAdminAdAnalytics extends ChartWidget
{
    protected static ?string $heading = 'Ad clicks (Last 6 Months)';
    // protected static ?string $heading = null;
    protected static string $color = 'success';
    public ?Model $record = null;

    // public function getHeading(): ?string
    // {
    //     return $this->record?->caption ?? 'Ad Analytics';
    // }

    protected function getData(): array
    {
        // $ad_id = \App\Models\Ad::where('is_active', true)
        //     ->where('display_in', 'Free')
        //     ->where('id', $this->record->id)
        //     ->pluck('id');

        $ad_id = \App\Models\Ad::where('id', $this->record->id)
            ->pluck('id');

        $data = Trend::query(
            Analytics::where('type', 'ad_click')
                ->where('ad_id', $ad_id)
        )
            ->dateColumn('clicked_at')
            ->between(
                start: now()->subMonths(5),
                end: now(),
            )
            ->perMonth()
            ->count();

        return [

            'datasets' => [
                [
                    'label' => 'Ad clicks per month',
                    'data' => $data->map(fn(TrendValue $value) => $value->aggregate),
                ],
            ],
            'labels' => $data->map(fn(TrendValue $value) => Carbon::parse($value->date)->format('M Y')),
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }
}
