<?php

namespace App\Filament\Resources\AdResource\Widgets;

use Carbon\Carbon;
use App\Models\Analytics;
use App\Models\Ad;
use Filament\Widgets\ChartWidget;
use Flowframe\Trend\Trend;
use Flowframe\Trend\TrendValue;

class AdminAdAnalytics extends ChartWidget
{
    protected static ?string $heading = 'Overall Ad clicks (Last 6 Months)';
    protected static string $color = 'success';

    protected function getData(): array
    {
        $adIds = \App\Models\Ad::where('is_active', true)
            ->where('display_in', 'Free')
            ->pluck('id');

        $data = Trend::query(
            Analytics::where('type', 'ad_click')
                ->whereIn('ad_id', $adIds)
        )
            ->dateColumn('clicked_at')
            ->between(
                start: now()->subMonths(5),
                end: now(),
            )
            ->perMonth()
            ->count();

        return [

            'datasets' => [
                [
                    'label' => 'Ad clicks per month',
                    'data' => $data->map(fn(TrendValue $value) => $value->aggregate),
                ],
            ],
            'labels' => $data->map(fn(TrendValue $value) => Carbon::parse($value->date)->format('M Y')),
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }

    // public function getColumnSpan(): int | string | array
    // {
    //     return 'full'; // Or you can return 2, 3, 12 based on your grid setup
    // }
}
