<?php

namespace App\Filament\Pages;

use App\Settings\CardDefaultsSetting;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;

class LegalAndCompliance extends SettingsPage
{
    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';

    protected static string $settings = CardDefaultsSetting::class;

    protected static ?string $title = 'Legal & Compliance';
    protected static ?string $navigationGroup = 'Settings';
    protected static ?string $navigationLabel = 'Legal & Compliance';
    // protected static ?string $slug = 'general-settings';
    protected static ?int $navigationSort = 10;

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\RichEditor::make('privacy_policy')
                    ->label('Privacy Policy')
                    ->required()
                    ->columnSpanFull(),
                Forms\Components\RichEditor::make('cookie_consent')
                    ->label('Cookie Consent')
                    ->required()
                    ->columnSpanFull(),
                Forms\Components\RichEditor::make('terms_conditions')
                    ->label('Terms & Conditions')
                    ->required()
                    ->columnSpanFull(),
            ]);
    }
}
