<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class UpdateReviewButtonsTitle extends Command
{
    /**
     * The name and signature of the console command.
     */
    protected $signature = 'buttons:update-reviews-title';

    /**
     * The console command description.
     */
    protected $description = 'Update the title of all buttons with type "reviews" to "Testimonials"';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $title = 'Testimonials';

        $affected = DB::table('buttons')
            ->where('type', 'reviews')
            ->update(['title' => $title]);

        $this->info("Updated {$affected} button(s) with type 'reviews' to '{$title}'.");

        return Command::SUCCESS;
    }
}
