<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Carbon\Carbon;

class DowngradeExpiredUsersNew extends Command
{
    protected $signature = 'users:downgrade-expired-new';
    protected $description = 'Downgrade users whose trial or subscription has ended';

    public function handle()
    {
        $now = Carbon::now();

        // 1️⃣ Handle trial users
        $trialUsers = User::whereNotNull('trial_ends_at')
            ->where('trial_ends_at', '<=', $now)
            ->whereIn('access', ['Year', 'Month', 'Trial', 'Custom'])
            ->get();

        foreach ($trialUsers as $user) {
            $user->user_type = 'Free';
            $user->access = null;
            $user->trial_ends_at = null;
            $user->save();

            $this->info("Trial expired: Downgraded user {$user->id} to Free.");
        }

        // 2️⃣ Handle paid subscriptions that ended or are incomplete
        // $paidUsers = User::whereIn('user_type', ['Basic', 'Gold', 'Platinum'])
        //     ->get();

        // foreach ($paidUsers as $user) {
        //     $subscription = $user->subscription('default');

        //     // if (!$subscription || $subscription->ended()) {
        //     if (!$subscription || $subscription->ended() || $subscription->stripe_status !== 'active') {
        //         $user->user_type = 'Free';
        //         $user->access = null;
        //         $user->trial_ends_at = null;
        //         $user->save();

        //         $this->info("Subscription ended: Downgraded user {$user->id} to Free.");
        //     }
        // }

        $this->info('Downgrade check complete.');
    }
}
