<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class DeactivateHelpAndFeedbackButtons extends Command
{
    /**
     * The name and signature of the console command.
     */
    protected $signature = 'buttons:deactivate-help-feedback';

    /**
     * The console command description.
     */
    protected $description = 'Set is_active to false for buttons where type is help or feedback';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $updated = DB::table('buttons')
            ->whereIn('type', ['help', 'feedback'])
            ->update(['is_active' => false]);

        $this->info("✅ {$updated} button(s) were deactivated successfully.");
    }
}
