<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Event;

class ConvertVideoLinks extends Command
{
    protected $signature = 'event:convert-video-links {--dry-run}';

    protected $description = 'Convert event_video_link string into double-encoded JSON array format';

    // public function handle()
    // {
    //     Event::whereNotNull('event_video_link')
    //         ->orderBy('id')
    //         ->chunkById(200, function ($events) {
    //             foreach ($events as $event) {
    //                 // Get the raw DB value (bypass casts)
    //                 $raw = $event->getRawOriginal('event_video_link');

    //                 if ($raw === null || trim($raw) === '') {
    //                     continue;
    //                 }

    //                 // Skip if already in desired format
    //                 if ($this->looksDoubleEncoded($raw)) {
    //                     continue;
    //                 }

    //                 // If $raw is a JSON string, try decoding once
    //                 $decoded = json_decode($raw, true);
    //                 if (is_array($decoded)) {
    //                     // Already array → pick first element or keep as array
    //                     $url = $decoded[0] ?? null;
    //                 } elseif (is_string($decoded)) {
    //                     // Case: "\"https://...\"" → unwrap
    //                     $url = $decoded;
    //                 } else {
    //                     // Otherwise, assume it's a plain string
    //                     $url = trim($raw);
    //                 }

    //                 if (! $url) {
    //                     continue;
    //                 }

    //                 // Build double-encoded JSON string
    //                 $array = [$url];
    //                 // $doubleEncoded = json_encode(json_encode($array, \JSON_HEX_SLASH));
    //                 $encoded = json_encode($array); // single encode is enough

    //                 if ($this->option('dry-run')) {
    //                     $this->line("Would update #{$event->id}: {$raw} → {$encoded}");
    //                     continue;
    //                 }

    //                 $event->forceFill([
    //                     'event_video_link' => $encoded,
    //                 ])->save();

    //                 $this->info("Updated #{$event->id}");
    //             }
    //         });

    //     $this->info('Done converting all event_video_links.');
    // }

    // public function handle()
    // {
    //     Event::whereNotNull('event_video_link')
    //         ->orderBy('id')
    //         ->chunkById(200, function ($events) {
    //             foreach ($events as $event) {
    //                 $raw = $event->getRawOriginal('event_video_link');

    //                 if (!$raw || trim($raw) === '') {
    //                     continue;
    //                 }

    //                 // Decode to check if it's already a JSON array
    //                 $decoded = json_decode($raw, true);

    //                 if (is_array($decoded) && count($decoded) === 1 && is_string($decoded[0])) {
    //                     // Already in the desired format
    //                     continue;
    //                 }

    //                 // Otherwise, treat as plain string and wrap in array
    //                 if (is_array($decoded) && count($decoded) > 0) {
    //                     // Take first URL from array if array exists
    //                     $url = $decoded[0];
    //                 } else {
    //                     $url = trim($raw);
    //                 }

    //                 $encoded = json_encode([$url]);

    //                 if ($this->option('dry-run')) {
    //                     $this->line("Would update #{$event->id}: {$raw} → {$encoded}");
    //                     continue;
    //                 }

    //                 $event->forceFill([
    //                     'event_video_link' => $encoded,
    //                 ])->save();

    //                 $this->info("Updated #{$event->id}");
    //             }
    //         });

    //     $this->info('Done converting all event_video_links.');
    // }

    public function handle()
    {
        Event::whereNotNull('event_video_link')
            ->orderBy('id')
            ->chunkById(200, function ($events) {
                foreach ($events as $event) {
                    $raw = $event->getRawOriginal('event_video_link');

                    if (!$raw || trim($raw) === '') {
                        continue;
                    }

                    // Decode to check if it's already a JSON array
                    $decoded = json_decode($raw, true);

                    if (is_array($decoded)) {
                        // Already an array → skip
                        $this->line("Skipping #{$event->id}, already an array.");
                        continue;
                    }

                    // Otherwise, treat as plain string and wrap in array
                    $url = trim($raw);
                    $encoded = json_encode([$url]);

                    if ($this->option('dry-run')) {
                        $this->line("Would update #{$event->id}: {$raw} → {$encoded}");
                        continue;
                    }

                    $event->forceFill([
                        'event_video_link' => $encoded,
                    ])->save();

                    $this->info("Updated #{$event->id}");
                }
            });

        $this->info('Done converting all event_video_links.');
    }

    private function looksDoubleEncoded(string $value): bool
    {
        // Detect if it already starts with [" and ends with "]
        return str_starts_with($value, '["') || str_starts_with($value, '"[\"');
    }
}
