<?php

namespace App\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Database\Eloquent\Model;

class MoneyCast implements CastsAttributes
{
    /**
     * Cast the given value.
     *
     * @param  array<string, mixed>  $attributes
     */
    public function get($model, string $key, $value, array $attributes): float
    {
        // Convert cents to dollars
        return round($value / 100, 2);
    }

    public function set($model, string $key, $value, array $attributes): int
    {
        // Ensure proper conversion of both integers and floats to cents
        return (int) round((float) $value * 100);
    }
}
